/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.util.Util;

public class Filter {
    public static final float[] createGaussianKernel(float sigma, boolean normalize) {
        float[] kernel;
        if (sigma <= 0.0f) {
            kernel = new float[3];
            kernel[1] = 1.0f;
        } else {
            int size = Math.max(3, 2 * (int)((double)(3.0f * sigma) + 0.5) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            kernel = new float[size];
            int x = size / 2;
            while (x >= 0) {
                float val;
                kernel[size / 2 - x] = val = (float)Math.exp(-((float)(x * x)) / two_sq_sigma);
                kernel[size / 2 + x] = val;
                --x;
            }
        }
        if (normalize) {
            float sum = 0.0f;
            float[] fArray = kernel;
            int n = kernel.length;
            int n2 = 0;
            while (n2 < n) {
                float value = fArray[n2];
                sum += value;
                ++n2;
            }
            int i = 0;
            while (i < kernel.length) {
                int n3 = i++;
                kernel[n3] = kernel[n3] / sum;
            }
        }
        return kernel;
    }

    public static final FloatArray2D createGaussianKernelOffset(float sigma, float offset_x, float offset_y, boolean normalize) {
        FloatArray2D kernel;
        if (sigma == 0.0f) {
            kernel = new FloatArray2D(3, 3);
            kernel.data[4] = 1.0f;
        } else {
            int size = Math.max(3, 2 * Math.round(3.0f * sigma) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            kernel = new FloatArray2D(size, size);
            int x = size - 1;
            while (x >= 0) {
                float fx = x - size / 2;
                int y = size - 1;
                while (y >= 0) {
                    float fy = y - size / 2;
                    float val = (float)Math.exp(-(Math.pow(fx - offset_x, 2.0) + Math.pow(fy - offset_y, 2.0)) / (double)two_sq_sigma);
                    kernel.set(val, x, y);
                    --y;
                }
                --x;
            }
        }
        if (normalize) {
            float sum = 0.0f;
            float[] fArray = kernel.data;
            int n = kernel.data.length;
            int n2 = 0;
            while (n2 < n) {
                float value = fArray[n2];
                sum += value;
                ++n2;
            }
            int i = 0;
            while (i < kernel.data.length) {
                int n3 = i++;
                kernel.data[n3] = kernel.data[n3] / sum;
            }
        }
        return kernel;
    }

    public static final FloatArray2D[] createGradients(FloatArray2D array) {
        FloatArray2D[] gradients = new FloatArray2D[]{new FloatArray2D(array.width, array.height), new FloatArray2D(array.width, array.height)};
        int y = 0;
        while (y < array.height) {
            int[] ro = new int[]{array.width * Math.max(0, y - 1), array.width * y, array.width * Math.min(y + 1, array.height - 1)};
            int x = 0;
            while (x < array.width) {
                float der_x = (array.data[ro[1] + Math.min(x + 1, array.width - 1)] - array.data[ro[1] + Math.max(0, x - 1)]) / 2.0f;
                float der_y = (array.data[ro[2] + x] - array.data[ro[0] + x]) / 2.0f;
                gradients[0].data[ro[1] + x] = (float)Math.sqrt(Math.pow(der_x, 2.0) + Math.pow(der_y, 2.0));
                gradients[1].data[ro[1] + x] = (float)Math.atan2(der_y, der_x);
                ++x;
            }
            ++y;
        }
        return gradients;
    }

    public static final void enhance(FloatArray2D src, float scale) {
        float min;
        float max = min = src.data[0];
        float[] fArray = src.data;
        int n = src.data.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (f < min) {
                min = f;
            } else if (f > max) {
                max = f;
            }
            ++n2;
        }
        float s = scale / (max - min);
        int i = 0;
        while (i < src.data.length) {
            src.data[i] = s * (src.data[i] - min);
            ++i;
        }
    }

    public static final FloatArray2D convolveSeparable(FloatArray2D input, float[] h, float[] v) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        FloatArray2D temp = new FloatArray2D(input.width, input.height);
        int hl = h.length / 2;
        int vl = v.length / 2;
        int xl = input.width - h.length + 1;
        int yl = input.height - v.length + 1;
        int[] xb = new int[h.length + hl - 1];
        int[] xa = new int[h.length + hl - 1];
        int i = 0;
        while (i < xb.length) {
            xb[i] = Util.pingPong(i - hl, input.width);
            xa[i] = Util.pingPong(i + xl, input.width);
            ++i;
        }
        int[] yb = new int[v.length + vl - 1];
        int[] ya = new int[v.length + vl - 1];
        int i2 = 0;
        while (i2 < yb.length) {
            yb[i2] = input.width * Util.pingPong(i2 - vl, input.height);
            ya[i2] = input.width * Util.pingPong(i2 + yl, input.height);
            ++i2;
        }
        xl += hl;
        yl += vl;
        int rl = input.height * input.width;
        int r = 0;
        while (r < rl) {
            int xk;
            int x = hl;
            while (x < xl) {
                int c = x - hl;
                float val = 0.0f;
                xk = 0;
                while (xk < h.length) {
                    val += h[xk] * input.data[r + c + xk];
                    ++xk;
                }
                temp.data[r + x] = val;
                ++x;
            }
            x = 0;
            while (x < hl) {
                float valb = 0.0f;
                float vala = 0.0f;
                xk = 0;
                while (xk < h.length) {
                    valb += h[xk] * input.data[r + xb[x + xk]];
                    vala += h[xk] * input.data[r + xa[x + xk]];
                    ++xk;
                }
                temp.data[r + x] = valb;
                temp.data[r + x + xl] = vala;
                ++x;
            }
            r += input.width;
        }
        int rm = yl * temp.width;
        int vlc = vl * temp.width;
        int x = 0;
        while (x < temp.width) {
            int yk;
            int r2 = vlc;
            while (r2 < rm) {
                float val = 0.0f;
                int c = r2 - vlc;
                int rk = 0;
                yk = 0;
                while (yk < v.length) {
                    val += v[yk] * temp.data[c + rk + x];
                    rk += temp.width;
                    ++yk;
                }
                output.data[r2 + x] = val;
                r2 += temp.width;
            }
            int y = 0;
            while (y < vl) {
                int r3 = y * temp.width;
                float valb = 0.0f;
                float vala = 0.0f;
                yk = 0;
                while (yk < v.length) {
                    valb += h[yk] * temp.data[yb[y + yk] + x];
                    vala += h[yk] * temp.data[ya[y + yk] + x];
                    ++yk;
                }
                output.data[r3 + x] = valb;
                output.data[r3 + rm + x] = vala;
                ++y;
            }
            ++x;
        }
        return output;
    }
}

