/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.io.Serializable;
import java.util.List;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public class Feature
implements Comparable<Feature>,
Serializable {
    private static final long serialVersionUID = -6425872941323995891L;
    public float scale;
    public float orientation;
    public float[] location;
    public float[] descriptor;

    public Feature() {
    }

    public Feature(float s, float o, float[] l, float[] d) {
        this.scale = s;
        this.orientation = o;
        this.location = l;
        this.descriptor = d;
    }

    @Override
    public final int compareTo(Feature f) {
        return this.scale < f.scale ? 1 : (this.scale == f.scale ? 0 : -1);
    }

    public final float descriptorDistance(Feature f) {
        float d = 0.0f;
        int i = 0;
        while (i < this.descriptor.length) {
            float a = this.descriptor[i] - f.descriptor[i];
            d += a * a;
            ++i;
        }
        return (float)Math.sqrt(d);
    }

    public static final int matchFeatures(List<Feature> fs1, List<Feature> fs2, List<PointMatch> matches, float rod) {
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            for (Feature f2 : fs2) {
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.add(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]})));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
        return matches.size();
    }
}

