/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.util;

import ij.gui.PointRoi;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public class Util {
    private Util() {
    }

    public static final PointRoi pointsToPointRoi(Collection<? extends Point> points) {
        float[] x = new float[points.size()];
        float[] y = new float[points.size()];
        int i = 0;
        for (Point point : points) {
            float[] l = point.getL();
            x[i] = l[0];
            y[i] = l[1];
            ++i;
        }
        return new PointRoi(x, y, x.length);
    }

    public static final List<Point> pointRoiToPoints(PointRoi roi) {
        FloatPolygon fp = roi.getFloatPolygon();
        float[] x = fp.xpoints;
        float[] y = fp.ypoints;
        ArrayList<Point> points = new ArrayList<Point>();
        int i = 0;
        while (i < x.length) {
            points.add(new Point(new float[]{x[i], y[i]}));
            ++i;
        }
        return points;
    }

    public static final List<PointMatch> pointRoisToPointMatches(PointRoi sourceRoi, PointRoi targetRoi) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        List<Point> sourcePoints = Util.pointRoiToPoints(sourceRoi);
        List<Point> targetPoints = Util.pointRoiToPoints(targetRoi);
        int numMatches = Math.min(sourcePoints.size(), targetPoints.size());
        int i = 0;
        while (i < numMatches) {
            matches.add(new PointMatch(sourcePoints.get(i), targetPoints.get(i)));
            ++i;
        }
        return matches;
    }

    public static final void fillWithNoise(ByteProcessor bp) {
        byte[] data = (byte[])bp.getPixels();
        Random random = new Random(System.nanoTime());
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)random.nextInt(256);
            ++i;
        }
    }

    public static final void fillWithNoise(FloatProcessor fp) {
        float[] data = (float[])fp.getPixels();
        Random random = new Random(System.nanoTime());
        int i = 0;
        while (i < data.length) {
            data[i] = random.nextFloat();
            ++i;
        }
    }

    public static final void fillWithNaN(FloatProcessor fp) {
        float[] data = (float[])fp.getPixels();
        int i = 0;
        while (i < data.length) {
            data[i] = Float.NaN;
            ++i;
        }
    }

    public static final void normalizeContrast(FloatProcessor fp) {
        float min;
        float[] data = (float[])fp.getPixels();
        float max = min = data[0];
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (f < min) {
                min = f;
            } else if (f > max) {
                max = f;
            }
            ++n2;
        }
        float s = 1.0f / (max - min);
        int i = 0;
        while (i < data.length) {
            data[i] = s * (data[i] - min);
            ++i;
        }
    }

    public static final Color createSaturatedColor(float i, float interval) {
        float o = i / interval * 6.0f;
        float a = 1.0f;
        float r = o < 3.0f ? Math.min(1.0f, Math.max(0.0f, 2.0f - o)) * 1.0f : Math.min(1.0f, Math.max(0.0f, o - 4.0f)) * 1.0f;
        if ((o += 2.0f) >= 6.0f) {
            o -= 6.0f;
        }
        float g = o < 3.0f ? Math.min(1.0f, Math.max(0.0f, 2.0f - o)) * 1.0f : Math.min(1.0f, Math.max(0.0f, o - 4.0f)) * 1.0f;
        if ((o += 2.0f) >= 6.0f) {
            o -= 6.0f;
        }
        float b = o < 3.0f ? Math.min(1.0f, Math.max(0.0f, 2.0f - o)) * 1.0f : Math.min(1.0f, Math.max(0.0f, o - 4.0f)) * 1.0f;
        return new Color(r, g, b);
    }

    public static final int colorVector(float xs, float ys) {
        double a = Math.sqrt(xs * xs + ys * ys);
        if (a == 0.0) {
            return 0;
        }
        double o = (Math.atan2((double)xs / a, (double)ys / a) + Math.PI) / Math.PI * 3.0;
        double r = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double g = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double b = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        return ((int)(r * 255.0) << 8 | (int)(g * 255.0)) << 8 | (int)(b * 255.0);
    }

    public static final void colorCircle(ColorProcessor ip) {
        int r1 = Math.min(ip.getWidth(), ip.getHeight()) / 2;
        int y = 0;
        while (y < ip.getHeight()) {
            float dy = y - ip.getHeight() / 2;
            int x = 0;
            while (x < ip.getWidth()) {
                float dx = x - ip.getWidth() / 2;
                float l = (float)Math.sqrt(dx * dx + dy * dy);
                if (l <= (float)r1) {
                    ip.putPixel(x, y, Util.colorVector(dx / (float)r1, dy / (float)r1));
                }
                ++x;
            }
            ++y;
        }
    }
}

