/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.util;

import ij.plugin.filter.GaussianBlur;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mpicbg.util.Util;

public class Filter {
    public static final void normalize(float[] data) {
        float sum = 0.0f;
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            sum += d;
            ++n2;
        }
        int i = 0;
        while (i < data.length) {
            int n3 = i++;
            data[n3] = data[n3] / sum;
        }
    }

    public static final float[] createGaussianKernel(float sigma) {
        float[] kernel;
        if (sigma <= 0.0f) {
            kernel = new float[]{1.0f};
        } else {
            int size = Math.max(3, 2 * (int)(3.0f * sigma + 0.5f) + 1);
            float twoSquareSigma = 2.0f * sigma * sigma;
            kernel = new float[size];
            int x = size / 2;
            while (x >= 0) {
                float val;
                kernel[size / 2 - x] = val = (float)Math.exp(-((float)(x * x)) / twoSquareSigma);
                kernel[size / 2 + x] = val;
                --x;
            }
        }
        return kernel;
    }

    public static final float[] createNormalizedGaussianKernel(float sigma) {
        float[] kernel = Filter.createGaussianKernel(sigma);
        Filter.normalize(kernel);
        return kernel;
    }

    public static final FloatProcessor createShiftedGaussianKernel(float sigma, float offsetX, float offsetY) {
        FloatProcessor kernel;
        if (sigma <= 0.0f) {
            kernel = new FloatProcessor(1, 1);
            kernel.setf(0, 1.0f);
        } else {
            int size = Math.max(3, 2 * Math.round(3.0f * sigma) + 1);
            float twoSquareSigma = 2.0f * sigma * sigma;
            kernel = new FloatProcessor(size, size);
            int x = size - 1;
            while (x >= 0) {
                float fx = x - size / 2;
                int y = size - 1;
                while (y >= 0) {
                    float fy = y - size / 2;
                    float val = (float)Math.exp(-(Math.pow(fx - offsetX, 2.0) + Math.pow(fy - offsetY, 2.0)) / (double)twoSquareSigma);
                    kernel.setf(x, y, val);
                    --y;
                }
                --x;
            }
        }
        return kernel;
    }

    public static final FloatProcessor createNormalizedShiftedGaussianKernel(float sigma, float offsetX, float offsetY) {
        FloatProcessor kernel = Filter.createShiftedGaussianKernel(sigma, offsetX, offsetY);
        Filter.normalize((float[])kernel.getPixels());
        return kernel;
    }

    public static final FloatProcessor[] createGradients(FloatProcessor array) {
        int width = array.getWidth();
        int height = array.getHeight();
        FloatProcessor[] gradients = new FloatProcessor[]{new FloatProcessor(width, height), new FloatProcessor(width, height)};
        float[] data = (float[])array.getPixels();
        float[] rData = (float[])gradients[0].getPixels();
        float[] phiData = (float[])gradients[1].getPixels();
        int y = 0;
        while (y < height) {
            int[] ro = new int[]{width * Math.max(0, y - 1), width * y, width * Math.min(y + 1, height - 1)};
            int x = 0;
            while (x < width) {
                float der_x = (data[ro[1] + Math.min(x + 1, width - 1)] - data[ro[1] + Math.max(0, x - 1)]) / 2.0f;
                float der_y = (data[ro[2] + x] - data[ro[0] + x]) / 2.0f;
                rData[ro[1] + x] = (float)Math.sqrt(Math.pow(der_x, 2.0) + Math.pow(der_y, 2.0));
                phiData[ro[1] + x] = (float)Math.atan2(der_y, der_x);
                ++x;
            }
            ++y;
        }
        return gradients;
    }

    public static final FloatProcessor createConvolveSeparable(FloatProcessor input, float[] h, float[] v) {
        FloatProcessor output = (FloatProcessor)input.duplicate();
        Filter.convolveSeparable(output, h, v);
        return output;
    }

    public static final void convolveSeparable(FloatProcessor input, float[] h, float[] v) {
        int width = input.getWidth();
        int height = input.getHeight();
        FloatProcessor temp = new FloatProcessor(width, height);
        float[] inputData = (float[])input.getPixels();
        float[] tempData = (float[])temp.getPixels();
        int hl = h.length / 2;
        int vl = v.length / 2;
        int xl = width - h.length + 1;
        int yl = height - v.length + 1;
        int[] xb = new int[h.length + hl - 1];
        int[] xa = new int[h.length + hl - 1];
        int i = 0;
        while (i < xb.length) {
            xb[i] = Util.pingPong(i - hl, width);
            xa[i] = Util.pingPong(i + xl, width);
            ++i;
        }
        int[] yb = new int[v.length + vl - 1];
        int[] ya = new int[v.length + vl - 1];
        int i2 = 0;
        while (i2 < yb.length) {
            yb[i2] = width * Util.pingPong(i2 - vl, height);
            ya[i2] = width * Util.pingPong(i2 + yl, height);
            ++i2;
        }
        xl += hl;
        yl += vl;
        int rl = height * width;
        int r = 0;
        while (r < rl) {
            int xk;
            int x = hl;
            while (x < xl) {
                int c = x - hl;
                float val = 0.0f;
                xk = 0;
                while (xk < h.length) {
                    val += h[xk] * inputData[r + c + xk];
                    ++xk;
                }
                tempData[r + x] = val;
                ++x;
            }
            x = 0;
            while (x < hl) {
                float valb = 0.0f;
                float vala = 0.0f;
                xk = 0;
                while (xk < h.length) {
                    valb += h[xk] * inputData[r + xb[x + xk]];
                    vala += h[xk] * inputData[r + xa[x + xk]];
                    ++xk;
                }
                tempData[r + x] = valb;
                tempData[r + x + xl] = vala;
                ++x;
            }
            r += width;
        }
        int rm = yl * width;
        int vlc = vl * width;
        int x = 0;
        while (x < width) {
            int yk;
            int r2 = vlc;
            while (r2 < rm) {
                float val = 0.0f;
                int c = r2 - vlc;
                int rk = 0;
                yk = 0;
                while (yk < v.length) {
                    val += v[yk] * tempData[c + rk + x];
                    rk += width;
                    ++yk;
                }
                inputData[r2 + x] = val;
                r2 += width;
            }
            int y = 0;
            while (y < vl) {
                int r3 = y * width;
                float valb = 0.0f;
                float vala = 0.0f;
                yk = 0;
                while (yk < v.length) {
                    valb += h[yk] * tempData[yb[y + yk] + x];
                    vala += h[yk] * tempData[ya[y + yk] + x];
                    ++yk;
                }
                inputData[r3 + x] = valb;
                inputData[r3 + rm + x] = vala;
                ++y;
            }
            ++x;
        }
    }

    public static final void smoothForScale(FloatProcessor source, float scale, float sourceSigma, float targetSigma) {
        assert (scale <= 1.0f) : "Downsampling requires a scale factor < 1.0";
        float s = targetSigma / scale;
        float v = s * s - sourceSigma * sourceSigma;
        if (v <= 0.0f) {
            return;
        }
        float sigma = (float)Math.sqrt(v);
        new GaussianBlur().blurFloat(source, (double)sigma, (double)sigma, 0.01);
    }

    public static final FloatProcessor createDownsampled(FloatProcessor source, float scale, float sourceSigma, float targetSigma) {
        assert (scale <= 1.0f) : "Downsampling requires a scale factor < 1.0";
        int ow = source.getWidth();
        int oh = source.getHeight();
        int w = Math.round((float)ow * scale);
        int h = Math.round((float)oh * scale);
        int l = Math.max(w, h);
        FloatProcessor temp = (FloatProcessor)source.duplicate();
        temp.setMinAndMax(source.getMin(), source.getMax());
        Filter.smoothForScale(temp, scale, sourceSigma, targetSigma);
        if (scale == 1.0f) {
            return temp;
        }
        float[] tempPixels = (float[])temp.getPixels();
        FloatProcessor target = new FloatProcessor(w, h);
        target.setMinAndMax(source.getMin(), source.getMax());
        float[] targetPixels = (float[])target.getPixels();
        int ow1 = ow - 1;
        int oh1 = oh - 1;
        int[] lutx = new int[l];
        int x = 0;
        while (x < w) {
            lutx[x] = Math.min(ow1, Math.max(0, Math.round((float)x / scale)));
            ++x;
        }
        int[] luty = new int[l];
        int y = 0;
        while (y < h) {
            luty[y] = Math.min(oh1, Math.max(0, Math.round((float)y / scale)));
            ++y;
        }
        y = 0;
        while (y < h) {
            int p = y * w;
            int q = luty[y] * ow;
            int x2 = 0;
            while (x2 < w) {
                targetPixels[p + x2] = tempPixels[q + lutx[x2]];
                ++x2;
            }
            ++y;
        }
        return target;
    }

    public static final void smoothForScale(ImageProcessor source, float scale, float sourceSigma, float targetSigma) {
        float s = targetSigma / scale;
        float v = s * s - sourceSigma * sourceSigma;
        if (v <= 0.0f) {
            return;
        }
        float sigma = (float)Math.sqrt(v);
        new GaussianBlur().blurGaussian(source, (double)sigma, (double)sigma, 0.01);
    }

    public static final ImageProcessor createDownsampled(ImageProcessor source, float scale, float sourceSigma, float targetSigma) {
        int ow = source.getWidth();
        int oh = source.getHeight();
        int w = Math.round((float)ow * scale);
        int h = Math.round((float)oh * scale);
        ImageProcessor temp = source.duplicate();
        temp.setMinAndMax(source.getMin(), source.getMax());
        Filter.smoothForScale(temp, scale, sourceSigma, targetSigma);
        if (scale >= 1.0f) {
            return temp;
        }
        ImageProcessor target = temp.resize(w, h);
        target.setMinAndMax(source.getMin(), source.getMax());
        return target;
    }

    public static final ImageProcessor scale(ImageProcessor source, float scale) {
        ImageProcessor target;
        if (scale == 1.0f) {
            target = source.duplicate();
        } else if (scale < 1.0f) {
            target = Filter.createDownsampled(source, scale, 0.5f, 0.5f);
        } else {
            source.setInterpolationMethod(1);
            target = source.resize(Math.round(scale * (float)source.getWidth()));
        }
        target.setMinAndMax(source.getMin(), source.getMax());
        return target;
    }
}

