/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.stack;

import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.stack.Mapping;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class InverseTransformMapping<T extends InverseCoordinateTransform>
implements Mapping<T> {
    private float z = 0.0f;
    protected final T transform;

    @Override
    public final T getTransform() {
        return this.transform;
    }

    public InverseTransformMapping(T t) {
        this.transform = t;
    }

    @Override
    public void map(ImageStack source, ImageProcessor target) {
        float[] t = new float[3];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int sd = source.getSize();
        int tw = target.getWidth();
        int th = target.getHeight();
        ImageProcessor slice = source.getProcessor(1);
        int y = 0;
        while (y < th) {
            int x = 0;
            while (x < tw) {
                t[0] = x;
                t[1] = y;
                t[2] = this.z;
                try {
                    this.transform.applyInverseInPlace(t);
                    int tx = (int)(t[0] + 0.5f);
                    int ty = (int)(t[1] + 0.5f);
                    int tz = (int)(t[2] + 1.5f);
                    if (tx >= 0 && tx <= sw && ty >= 0 && ty <= sh && tz >= 1 && tz <= sd) {
                        slice.setPixels(source.getPixels(tz));
                        target.putPixel(x, y, slice.getPixel(tx, ty));
                    }
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void mapInterpolated(ImageStack source, ImageProcessor target) {
        float[] t = new float[3];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int sd = source.getSize();
        int tw = target.getWidth();
        int th = target.getHeight();
        ImageProcessor slice = source.getProcessor(1);
        slice.setInterpolationMethod(1);
        Interpolator interpolator = ByteProcessor.class.isInstance(slice) ? new ByteInterpolator() : (ShortProcessor.class.isInstance(slice) ? new ShortInterpolator() : (FloatProcessor.class.isInstance(slice) ? new FloatInterpolator() : (ColorProcessor.class.isInstance(slice) ? new RGBInterpolator() : null)));
        int y = 0;
        while (y < th) {
            int x = 0;
            while (x < tw) {
                t[0] = x;
                t[1] = y;
                t[2] = this.z;
                try {
                    this.transform.applyInverseInPlace(t);
                    int tza = (int)(t[2] + 1.0f);
                    int tzb = (int)(t[2] + 2.0f);
                    if (t[0] >= 0.0f && t[0] <= (float)sw && t[1] >= 0.0f && t[1] <= (float)sh && tza >= 1 && tzb <= sd) {
                        slice.setPixels(source.getPixels(tza));
                        int a = slice.getPixelInterpolated((double)t[0], (double)t[1]);
                        slice.setPixels(source.getPixels(tzb));
                        int b = slice.getPixelInterpolated((double)t[0], (double)t[1]);
                        target.putPixel(x, y, interpolator.interpolate(a, b, t[2] - (float)tza + 1.0f));
                    }
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void setSlice(float z) {
        this.z = z;
    }

    public static class ByteInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, float da) {
            float fa = a & 0xFF;
            float fb = b & 0xFF;
            return Math.round(ByteInterpolator.interpolate(fa, fb, da));
        }
    }

    public static class FloatInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, float da) {
            double fa = Float.intBitsToFloat(a);
            double fb = Float.intBitsToFloat(b);
            return Float.floatToIntBits((float)FloatInterpolator.interpolate(fa, fb, da));
        }
    }

    public static abstract class Interpolator {
        public abstract int interpolate(int var1, int var2, float var3);

        protected static final float interpolate(float a, float b, float da) {
            return da * (b - a) + a;
        }

        protected static final double interpolate(double a, double b, float da) {
            return (double)da * (b - a) + a;
        }
    }

    public static class RGBInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, float da) {
            float fra = a >> 16 & 0xFF;
            float frb = b >> 16 & 0xFF;
            float fga = a >> 8 & 0xFF;
            float fgb = b >> 8 & 0xFF;
            float fba = a & 0xFF;
            float fbb = b & 0xFF;
            float fr = RGBInterpolator.interpolate(fra, frb, da);
            float fg = RGBInterpolator.interpolate(fga, fgb, da);
            float fb = RGBInterpolator.interpolate(fba, fbb, da);
            return Math.round(fr) << 16 | Math.round(fg) << 8 | Math.round(fb);
        }
    }

    public static class ShortInterpolator
    extends Interpolator {
        @Override
        public int interpolate(int a, int b, float da) {
            float fa = a & 0xFFFF;
            float fb = b & 0xFFFF;
            return Math.round(ShortInterpolator.interpolate(fa, fb, da));
        }
    }
}

