/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.integral.DoubleIntegralImage;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.ij.integral.LongIntegralImage;
import mpicbg.ij.integral.LongRGBIntegralImage;

public class Tilt {
    private final IntegralImage integral;
    private final ImageProcessor ip;

    public Tilt(ColorProcessor ip) {
        this.ip = ip;
        this.integral = new LongRGBIntegralImage(ip);
    }

    public Tilt(ByteProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
    }

    public Tilt(ShortProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
    }

    public Tilt(FloatProcessor ip) {
        this.ip = ip;
        this.integral = new DoubleIntegralImage(ip);
    }

    public static final Tilt create(ImageProcessor ip) {
        if (FloatProcessor.class.isInstance(ip)) {
            return new Tilt((FloatProcessor)ip);
        }
        if (ByteProcessor.class.isInstance(ip)) {
            return new Tilt((ByteProcessor)ip);
        }
        if (ShortProcessor.class.isInstance(ip)) {
            return new Tilt((ShortProcessor)ip);
        }
        if (ColorProcessor.class.isInstance(ip)) {
            return new Tilt((ColorProcessor)ip);
        }
        return null;
    }

    public void render(int x1, int y1, int x2, int y2) {
        int w = this.ip.getWidth() - 1;
        int h = this.ip.getHeight() - 1;
        double s = (double)(this.ip.getWidth() + this.ip.getHeight()) * 2.0;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int y = 0;
        while (y <= h) {
            double yt = y - y1;
            int x = 0;
            while (x <= w) {
                double xt = x - x1;
                double r = ((double)dx * xt + (double)dy * yt) / s;
                int ri = r < 0.0 ? (int)(-r) : (int)r;
                int yMin = Math.max(-1, y - ri - 1);
                int yMax = Math.min(h, y + ri);
                int bh = yMax - yMin;
                int xMin = Math.max(-1, x - ri - 1);
                int xMax = Math.min(w, x + ri);
                float scale = 1.0f / (float)(xMax - xMin) / (float)bh;
                this.ip.set(x, y, this.integral.getScaledSum(xMin, yMin, xMax, yMax, scale));
                ++x;
            }
            ++y;
        }
    }
}

