/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.FloatProcessor;
import mpicbg.ij.integral.BlockStatistics;

public class RemoveOutliers
extends BlockStatistics {
    protected final FloatProcessor fpOriginal;

    public RemoveOutliers(FloatProcessor fp) {
        super(fp);
        this.fpOriginal = (FloatProcessor)fp.duplicate();
    }

    public void removeOutliers(int blockRadiusX, int blockRadiusY, float meanFactor) {
        int numSaturatedPixelsBefore;
        this.fp.setPixels(this.fpOriginal.getPixelsCopy());
        int width = this.fp.getWidth();
        int height = this.fp.getHeight();
        int wh = width * height;
        int w = width - 1;
        int h = height - 1;
        int y = 0;
        while (y < height) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            int x = 0;
            while (x < width) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale = 1.0 / (double)bs;
                double scale1 = 1.0 / (double)(bs - 1L);
                double scale2 = 1.0 / (double)(bs * bs - bs);
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale1 * this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - scale2 * sum * sum;
                int i = row + x;
                float mean = (float)(sum * scale);
                float std = var < 0.0 ? 0.0f : (float)Math.sqrt(var);
                float v = this.fp.getf(i);
                float min = mean - meanFactor * std;
                float max = mean + meanFactor * std;
                if (v < min || v > max) {
                    this.fp.setf(i, Float.NaN);
                }
                ++x;
            }
            ++y;
        }
        FloatProcessor fpCopy = (FloatProcessor)this.fp.duplicate();
        int numSaturatedPixels = 0;
        do {
            numSaturatedPixelsBefore = numSaturatedPixels;
            numSaturatedPixels = 0;
            int i = 0;
            while (i < wh) {
                float v = this.fp.getf(i);
                if (Float.isNaN(v)) {
                    float r;
                    float l;
                    ++numSaturatedPixels;
                    int y2 = i / width;
                    int x = i % width;
                    float s = 0.0f;
                    float n = 0.0f;
                    if (y2 > 0) {
                        float tr;
                        float t;
                        float tl;
                        if (x > 0 && !Float.isNaN(tl = this.fp.getf(x - 1, y2 - 1))) {
                            s += 0.5f * tl;
                            n += 0.5f;
                        }
                        if (!Float.isNaN(t = this.fp.getf(x, y2 - 1))) {
                            s += t;
                            n += 1.0f;
                        }
                        if (x < w - 1 && !Float.isNaN(tr = this.fp.getf(x + 1, y2 - 1))) {
                            s += 0.5f * tr;
                            n += 0.5f;
                        }
                    }
                    if (x > 0 && !Float.isNaN(l = this.fp.getf(x - 1, y2))) {
                        s += l;
                        n += 1.0f;
                    }
                    if (x < w - 1 && !Float.isNaN(r = this.fp.getf(x + 1, y2))) {
                        s += r;
                        n += 1.0f;
                    }
                    if (y2 < h - 1) {
                        float br;
                        float b;
                        float bl;
                        if (x > 0 && !Float.isNaN(bl = this.fp.getf(x - 1, y2 + 1))) {
                            s += 0.5f * bl;
                            n += 0.5f;
                        }
                        if (!Float.isNaN(b = this.fp.getf(x, y2 + 1))) {
                            s += b;
                            n += 1.0f;
                        }
                        if (x < w - 1 && !Float.isNaN(br = this.fp.getf(x + 1, y2 + 1))) {
                            s += 0.5f * br;
                            n += 0.5f;
                        }
                    }
                    if (n > 0.0f) {
                        fpCopy.setf(i, s / n);
                    }
                }
                ++i;
            }
            this.fp.setPixels(fpCopy.getPixelsCopy());
        } while (numSaturatedPixels != numSaturatedPixelsBefore);
    }
}

