/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.IJ;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import mpicbg.ij.integral.AbstractInteractiveBlockFilter;
import mpicbg.ij.integral.DoubleIntegralImage;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.ij.integral.LongIntegralImage;
import mpicbg.ij.integral.LongRGBIntegralImage;

public final class InteractiveScale
extends AbstractInteractiveBlockFilter {
    private IntegralImage integral;
    private ImageProcessor ipCopy;
    private boolean useIntegral = true;

    @Override
    protected final void init() {
        switch (this.imp.getType()) {
            case 2: {
                this.integral = new DoubleIntegralImage(this.imp.getProcessor());
                break;
            }
            case 0: 
            case 1: {
                this.integral = new LongIntegralImage(this.imp.getProcessor());
                break;
            }
            case 4: {
                this.integral = new LongRGBIntegralImage((ColorProcessor)this.imp.getProcessor());
                break;
            }
            default: {
                IJ.error((String)"Type not yet supported.");
                return;
            }
        }
        this.ipCopy = this.imp.getProcessor().duplicate();
        if (this.imp.getRoi() != null) {
            Roi roi = this.imp.getRoi();
        } else {
            Roi roi = new Roi(this.imp.getWidth() / 4, this.imp.getHeight() / 4, this.imp.getWidth() / 2, this.imp.getHeight() / 2);
            this.imp.setRoi(roi);
        }
    }

    @Override
    protected final void draw() {
        ImageProcessor ip = this.imp.getProcessor();
        int w = this.imp.getWidth() - 1;
        int h = this.imp.getHeight() - 1;
        Roi roi = this.imp.getRoi();
        Rectangle rect = roi != null ? roi.getBounds() : new Rectangle(this.imp.getWidth(), this.imp.getHeight());
        int i = this.imp.getWidth() * rect.y - 1;
        while (i >= 0) {
            ip.set(i, 0);
            --i;
        }
        int n = this.imp.getWidth() * this.imp.getHeight();
        int i2 = this.imp.getWidth() * (rect.y + rect.height) - 1;
        while (i2 < n) {
            ip.set(i2, 0);
            ++i2;
        }
        int m = rect.y * this.imp.getWidth();
        int l = m + rect.height * this.imp.getWidth();
        int y = m;
        while (y < l) {
            int x = 0;
            while (x < rect.x) {
                ip.set(y + x, 0);
                ++x;
            }
            x = rect.x + rect.width;
            while (x <= w) {
                ip.set(y + x, 0);
                ++x;
            }
            y += this.imp.getWidth();
        }
        double pixelWidth = (double)this.imp.getWidth() / (double)rect.width;
        double pixelHeight = (double)this.imp.getHeight() / (double)rect.height;
        if (this.useIntegral) {
            int y2 = 0;
            while (y2 < rect.height) {
                int yi = this.imp.getWidth() * Math.min(h, Math.max(0, y2 + rect.y));
                double yMinDouble = (double)y2 * pixelHeight;
                int yMin = Math.min(h, Math.max(-1, (int)Math.round(yMinDouble) - 1));
                int yMax = Math.max(-1, Math.min(h, (int)Math.round(yMinDouble + pixelHeight - 1.0)));
                int bh = yMax - yMin;
                int x = 0;
                while (x < rect.width) {
                    int xi = Math.min(w, Math.max(0, x + rect.x));
                    double xMinDouble = (double)x * pixelWidth;
                    int xMin = Math.min(w, Math.max(-1, (int)Math.round(xMinDouble) - 1));
                    int xMax = Math.min(w, Math.max(-1, (int)Math.round(xMinDouble + pixelWidth - 1.0)));
                    float scale = 1.0f / (float)(xMax - xMin) / (float)bh;
                    ip.set(yi + xi, this.integral.getScaledSum(xMin, yMin, xMax, yMax, scale));
                    ++x;
                }
                ++y2;
            }
        } else {
            int y3 = 0;
            while (y3 < rect.height) {
                int ys = this.imp.getWidth() * (int)Math.round((double)y3 * pixelHeight);
                int yi = this.imp.getWidth() * Math.min(h, Math.max(0, y3 + rect.y));
                int x = 0;
                while (x < rect.width) {
                    int xs = (int)Math.round((double)x * pixelWidth);
                    int xi = Math.min(w, Math.max(0, x + rect.x));
                    ip.set(yi + xi, this.ipCopy.get(ys + xs));
                    ++x;
                }
                ++y3;
            }
        }
    }

    @Override
    protected final void showHelp() {
        IJ.showMessage((String)"Interactive Mean Smooth", (String)("Click and drag to change the size of the smoothing kernel." + NL + "U - Toggle integral sampling" + NL + "ENTER - Apply" + NL + "ESC - Cancel"));
    }
}

