/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.IJ;
import ij.ImageStack;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import mpicbg.ij.integral.AbstractInteractiveBlockFilter;
import mpicbg.ij.integral.BlockPMCC;

public class InteractivePMCC
extends AbstractInteractiveBlockFilter {
    protected BlockPMCC bc;
    private int offsetX = 0;
    private int offsetY = 0;
    private AtomicBoolean move = new AtomicBoolean(true);
    private ImageStack stackOriginal;
    private FloatProcessor fpR;
    private FloatProcessor fpR2;

    @Override
    protected final void init() {
        FloatProcessor fp2;
        FloatProcessor fp1;
        this.stackOriginal = this.imp.getStack();
        if (this.imp.getType() == 2) {
            fp1 = (FloatProcessor)this.stackOriginal.getProcessor(1).duplicate();
            fp2 = (FloatProcessor)this.stackOriginal.getProcessor(2).duplicate();
        } else {
            fp1 = (FloatProcessor)this.stackOriginal.getProcessor(1).convertToFloat();
            fp2 = (FloatProcessor)this.stackOriginal.getProcessor(2).convertToFloat();
        }
        this.bc = new BlockPMCC(fp1, fp2);
        this.fpR = this.bc.getTargetProcessor();
        this.fpR.setMinAndMax(-1.0, 1.0);
        this.fpR2 = (FloatProcessor)this.fpR.duplicate();
        ImageStack stack = new ImageStack(this.fpR.getWidth(), this.fpR.getHeight());
        stack.addSlice("r", (ImageProcessor)this.fpR2);
        this.imp.setStack(stack);
    }

    @Override
    public void run(String arg) {
        this.ij = IJ.getInstance();
        this.imp = IJ.getImage();
        if (this.imp.getStackSize() < 2) {
            IJ.error((String)"This plugin only works on stacks with at least two slices.");
            return;
        }
        this.window = this.imp.getWindow();
        this.canvas = this.imp.getCanvas();
        this.canvas.addKeyListener(this);
        this.window.addKeyListener((KeyListener)this);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addMouseListener(this);
        this.ij.addKeyListener((KeyListener)this);
        this.init();
        this.imp.getProcessor().snapshot();
        Toolbar.getInstance().setTool(0);
        this.painter = new AbstractInteractiveBlockFilter.PaintThread();
        this.painter.start();
    }

    protected void calculate() {
        this.bc.r(this.blockRadiusX, this.blockRadiusY);
    }

    @Override
    protected final void draw() {
        int shiftX = Math.max(0, this.offsetX);
        int shiftY = Math.max(0, this.offsetY);
        if (this.move.compareAndSet(true, false)) {
            this.bc.setOffset(this.offsetX, this.offsetY);
        }
        int i = this.fpR2.getPixelCount() - 1;
        while (i >= 0) {
            this.fpR.setf(i, 0.0f);
            this.fpR2.setf(i, 0.0f);
            --i;
        }
        this.calculate();
        this.fpR2.copyBits((ImageProcessor)this.fpR, shiftX, shiftY, 0);
    }

    @Override
    protected void showHelp() {
        IJ.showMessage((String)"Interactive Block Correlation", (String)("Click and drag to change the block size." + NL + "ENTER - Apply" + NL + "ESC - Cancel"));
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle bounds = this.imp.getRoi().getBounds();
            this.blockRadiusX = bounds.width / 2;
            this.blockRadiusY = bounds.height / 2;
            this.offsetX = bounds.x + (bounds.width - this.imp.getWidth()) / 2;
            this.offsetY = bounds.y + (bounds.height - this.imp.getHeight()) / 2;
            this.move.set(true);
        } else {
            this.blockRadiusX = 0;
            this.blockRadiusY = 0;
        }
        this.painter.repaint();
    }

    @Override
    public final void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            this.canvas.removeKeyListener(this);
            this.window.removeKeyListener((KeyListener)this);
            this.ij.removeKeyListener((KeyListener)this);
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            if (this.imp != null) {
                if (e.getKeyCode() == 27) {
                    this.imp.setStack(this.stackOriginal);
                } else {
                    e.getKeyCode();
                }
            }
            this.imp.updateAndDraw();
        } else if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            if (e.getKeyCode() == 37) {
                --this.offsetX;
            } else if (e.getKeyCode() == 39) {
                ++this.offsetX;
            } else if (e.getKeyCode() == 38) {
                --this.offsetY;
            } else if (e.getKeyCode() == 40) {
                ++this.offsetY;
            }
            this.move.set(true);
            this.painter.repaint();
        } else if (e.getKeyCode() == 112) {
            this.showHelp();
        }
    }
}

