/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.IJ;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import mpicbg.ij.integral.AbstractInteractiveBlockFilter;
import mpicbg.ij.integral.DifferenceOfMean;

public final class InteractiveDifferenceOfMean
extends AbstractInteractiveBlockFilter
implements MouseWheelListener {
    private int blockRadiusX1 = 0;
    private int blockRadiusY1 = 0;
    private int blockRadiusX2 = 0;
    private int blockRadiusY2 = 0;
    private DifferenceOfMean dom;
    private double min;
    private double max;
    private static final int dpScale = 10;
    private int dp = -10;

    private static final float d(int dp) {
        return (float)Math.pow(2.0, (double)dp / 10.0);
    }

    @Override
    protected final void init() {
        this.window.addMouseWheelListener((MouseWheelListener)this);
        ImageProcessor ip = this.imp.getProcessor();
        this.min = ip.getMin();
        this.max = ip.getMax();
        ip.snapshot();
        if (this.imp.getType() == 2) {
            ip.setMinAndMax((this.min - this.max) / 2.0, (this.max - this.min) / 2.0);
        } else if (this.imp.getType() == 1) {
            ip.setMinAndMax(32767.0 - (this.max - this.min) / 2.0, 32767.0 + (this.max - this.min) / 2.0);
        }
        this.dom = DifferenceOfMean.create(ip);
        this.dp = -10;
    }

    @Override
    protected final void draw() {
        this.dom.differenceOfMean(this.blockRadiusX1, this.blockRadiusY1, this.blockRadiusX2, this.blockRadiusY2);
    }

    @Override
    protected final void showHelp() {
        IJ.showMessage((String)"Interactive Difference of Means", (String)("Click and drag to change the size of the smoothing kernel." + NL + "ENTER - Apply" + NL + "ESC - Cancel"));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            this.canvas.removeKeyListener(this);
            this.window.removeKeyListener((KeyListener)this);
            this.window.removeMouseWheelListener((MouseWheelListener)this);
            this.ij.removeKeyListener((KeyListener)this);
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            if (this.imp != null) {
                if (e.getKeyCode() == 27) {
                    ImageProcessor ip = this.imp.getProcessor();
                    ip.reset();
                    ip.setMinAndMax(this.min, this.max);
                } else {
                    e.getKeyCode();
                }
            }
            this.imp.updateAndDraw();
        } else if (e.getKeyCode() == 112) {
            this.showHelp();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int s = e.getWheelRotation();
        if (s < 0) {
            e.consume();
            ++this.dp;
        } else {
            e.consume();
            --this.dp;
        }
        this.blockRadiusX1 = Math.round((float)this.blockRadiusX2 * InteractiveDifferenceOfMean.d(this.dp));
        this.blockRadiusY1 = Math.round((float)this.blockRadiusY2 * InteractiveDifferenceOfMean.d(this.dp));
        this.painter.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle bounds = this.imp.getRoi().getBounds();
            this.blockRadiusX2 = bounds.width / 2;
            this.blockRadiusY2 = bounds.height / 2;
            this.blockRadiusX1 = Math.round((float)this.blockRadiusX2 * InteractiveDifferenceOfMean.d(this.dp));
            this.blockRadiusY1 = Math.round((float)this.blockRadiusY2 * InteractiveDifferenceOfMean.d(this.dp));
        } else {
            this.blockRadiusX1 = 0;
            this.blockRadiusY1 = 0;
            this.blockRadiusX2 = 0;
            this.blockRadiusY2 = 0;
        }
        this.painter.repaint();
    }
}

