/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.integral.DoubleIntegralImage;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.ij.integral.LongIntegralImage;
import mpicbg.ij.integral.LongRGBIntegralImage;

public final class DifferenceOfMean {
    private final IntegralImage integral;
    private final ImageProcessor ip;
    private final int type;

    public DifferenceOfMean(ColorProcessor ip) {
        this.ip = ip;
        this.integral = new LongRGBIntegralImage(ip);
        this.type = 4;
    }

    public DifferenceOfMean(ByteProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
        this.type = 0;
    }

    public DifferenceOfMean(ShortProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
        this.type = 1;
    }

    public DifferenceOfMean(FloatProcessor ip) {
        this.ip = ip;
        this.integral = new DoubleIntegralImage(ip);
        this.type = 2;
    }

    private static final int roundPositive(float f) {
        return (int)(f + 0.5f);
    }

    private static final int crop(int a, int min, int max) {
        return a < min ? min : (a > max ? max : a);
    }

    private static final void differenceOfMeanFloat(FloatProcessor ip, DoubleIntegralImage integral, int blockRadiusX1, int blockRadiusY1, int blockRadiusX2, int blockRadiusY2) {
        int w = ip.getWidth() - 1;
        int h = ip.getHeight() - 1;
        int y = 0;
        while (y <= h) {
            int row = y * ip.getWidth();
            int yMin1 = Math.max(-1, y - blockRadiusY1 - 1);
            int yMax1 = Math.min(h, y + blockRadiusY1);
            int bh1 = yMax1 - yMin1;
            int yMin2 = Math.max(-1, y - blockRadiusY2 - 1);
            int yMax2 = Math.min(h, y + blockRadiusY2);
            int bh2 = yMax2 - yMin2;
            int x = 0;
            while (x <= w) {
                int xMin1 = Math.max(-1, x - blockRadiusX1 - 1);
                int xMax1 = Math.min(w, x + blockRadiusX1);
                float scale1 = 1.0f / (float)(xMax1 - xMin1) / (float)bh1;
                int xMin2 = Math.max(-1, x - blockRadiusX2 - 1);
                int xMax2 = Math.min(w, x + blockRadiusX2);
                float scale2 = 1.0f / (float)(xMax2 - xMin2) / (float)bh2;
                ip.setf(row + x, (float)(integral.getDoubleSum(xMin1, yMin1, xMax1, yMax1) * (double)scale1 - integral.getDoubleSum(xMin2, yMin2, xMax2, yMax2) * (double)scale2));
                ++x;
            }
            ++y;
        }
    }

    private static final void differenceOfMeanLong(ImageProcessor ip, LongIntegralImage integral, int blockRadiusX1, int blockRadiusY1, int blockRadiusX2, int blockRadiusY2, int offset, int min, int max) {
        int w = ip.getWidth() - 1;
        int h = ip.getHeight() - 1;
        int y = 0;
        while (y <= h) {
            int row = y * ip.getWidth();
            int yMin1 = Math.max(-1, y - blockRadiusY1 - 1);
            int yMax1 = Math.min(h, y + blockRadiusY1);
            int bh1 = yMax1 - yMin1;
            int yMin2 = Math.max(-1, y - blockRadiusY2 - 1);
            int yMax2 = Math.min(h, y + blockRadiusY2);
            int bh2 = yMax2 - yMin2;
            int x = 0;
            while (x <= w) {
                int xMin1 = Math.max(-1, x - blockRadiusX1 - 1);
                int xMax1 = Math.min(w, x + blockRadiusX1);
                float scale1 = 1.0f / (float)(xMax1 - xMin1) / (float)bh1;
                int xMin2 = Math.max(-1, x - blockRadiusX2 - 1);
                int xMax2 = Math.min(w, x + blockRadiusX2);
                float scale2 = 1.0f / (float)(xMax2 - xMin2) / (float)bh2;
                ip.set(row + x, DifferenceOfMean.roundPositive((float)integral.getLongSum(xMin1, yMin1, xMax1, yMax1) * scale1 - (float)integral.getLongSum(xMin2, yMin2, xMax2, yMax2) * scale2) + offset);
                ++x;
            }
            ++y;
        }
    }

    private static final void differenceOfMeanLongRGB(ColorProcessor ip, LongRGBIntegralImage integral, int blockRadiusX1, int blockRadiusY1, int blockRadiusX2, int blockRadiusY2, int offset) {
        int w = ip.getWidth() - 1;
        int h = ip.getHeight() - 1;
        long[] rgb1 = new long[3];
        long[] rgb2 = new long[3];
        int y = 0;
        while (y <= h) {
            int row = y * ip.getWidth();
            int yMin1 = Math.max(-1, y - blockRadiusY1 - 1);
            int yMax1 = Math.min(h, y + blockRadiusY1);
            int bh1 = yMax1 - yMin1;
            int yMin2 = Math.max(-1, y - blockRadiusY2 - 1);
            int yMax2 = Math.min(h, y + blockRadiusY2);
            int bh2 = yMax2 - yMin2;
            int x = 0;
            while (x <= w) {
                int xMin1 = Math.max(-1, x - blockRadiusX1 - 1);
                int xMax1 = Math.min(w, x + blockRadiusX1);
                float scale1 = 1.0f / (float)(xMax1 - xMin1) / (float)bh1;
                int xMin2 = Math.max(-1, x - blockRadiusX2 - 1);
                int xMax2 = Math.min(w, x + blockRadiusX2);
                float scale2 = 1.0f / (float)(xMax2 - xMin2) / (float)bh2;
                integral.longSums(rgb1, xMin1, yMin1, xMax1, yMax1);
                integral.longSums(rgb2, xMin2, yMin2, xMax2, yMax2);
                int r = DifferenceOfMean.crop(DifferenceOfMean.roundPositive((float)rgb1[0] * scale1 - (float)rgb2[0] * scale2) + offset, 0, 255);
                int g = DifferenceOfMean.crop(DifferenceOfMean.roundPositive((float)rgb1[1] * scale1 - (float)rgb2[1] * scale2) + offset, 0, 255);
                int b = DifferenceOfMean.crop(DifferenceOfMean.roundPositive((float)rgb1[2] * scale1 - (float)rgb2[2] * scale2) + offset, 0, 255);
                ip.set(row + x, (r << 8 | g) << 8 | b);
                ++x;
            }
            ++y;
        }
    }

    public final void differenceOfMean(int blockRadiusX1, int blockRadiusY1, int blockRadiusX2, int blockRadiusY2) {
        switch (this.type) {
            case 2: {
                DifferenceOfMean.differenceOfMeanFloat((FloatProcessor)this.ip, (DoubleIntegralImage)this.integral, blockRadiusX1, blockRadiusY1, blockRadiusX2, blockRadiusY2);
                break;
            }
            case 0: {
                DifferenceOfMean.differenceOfMeanLong(this.ip, (LongIntegralImage)this.integral, blockRadiusX1, blockRadiusY1, blockRadiusX2, blockRadiusY2, 127, 0, 255);
                break;
            }
            case 1: {
                DifferenceOfMean.differenceOfMeanLong(this.ip, (LongIntegralImage)this.integral, blockRadiusX1, blockRadiusY1, blockRadiusX2, blockRadiusY2, Short.MAX_VALUE, 0, 65535);
                break;
            }
            case 4: {
                DifferenceOfMean.differenceOfMeanLongRGB((ColorProcessor)this.ip, (LongRGBIntegralImage)this.integral, blockRadiusX1, blockRadiusY1, blockRadiusX2, blockRadiusY2, 127);
            }
        }
    }

    public final void differenceOfMean(int blockRadius1, int blockRadius2) {
        this.differenceOfMean(blockRadius1, blockRadius1, blockRadius2, blockRadius2);
    }

    public static final DifferenceOfMean create(ImageProcessor ip) {
        if (FloatProcessor.class.isInstance(ip)) {
            return new DifferenceOfMean((FloatProcessor)ip);
        }
        if (ByteProcessor.class.isInstance(ip)) {
            return new DifferenceOfMean((ByteProcessor)ip);
        }
        if (ShortProcessor.class.isInstance(ip)) {
            return new DifferenceOfMean((ShortProcessor)ip);
        }
        if (ColorProcessor.class.isInstance(ip)) {
            return new DifferenceOfMean((ColorProcessor)ip);
        }
        return null;
    }
}

