/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.FloatProcessor;
import mpicbg.ij.integral.DoubleIntegralImage;

public final class BlockPMCC {
    private final DoubleIntegralImage sumsX;
    private final DoubleIntegralImage sumsY;
    private final DoubleIntegralImage sumsXX;
    private final DoubleIntegralImage sumsYY;
    private final DoubleIntegralImage sumsXY;
    private final FloatProcessor fpX;
    private final FloatProcessor fpY;
    private final FloatProcessor fpR;
    private int fpXYWidth;
    private int fpXYHeight;
    private int offsetXX;
    private int offsetYX;
    private int offsetXY;
    private int offsetYY;

    private static final void sumAndSumOfSquares(FloatProcessor fp, double[] sum, double[] sumOfSquares) {
        int width = fp.getWidth();
        int height = fp.getHeight();
        int w = width + 1;
        int w1 = w + 1;
        int w2 = w + w;
        int n = w * height + w;
        int n1 = n - w1;
        int n2 = n1 - w + 2;
        int i = 0;
        int j = w1;
        while (j < n) {
            int end = i + width;
            double s = sum[j] = (double)fp.getf(i);
            double ss = sumOfSquares[j] = s * s;
            ++i;
            ++j;
            while (i < end) {
                float a = fp.getf(i);
                sum[j] = s += (double)a;
                sumOfSquares[j] = ss += (double)(a * a);
                ++i;
                ++j;
            }
            ++j;
        }
        int j2 = w1;
        while (j2 < w2) {
            int end = j2 + n2;
            double s = sum[j2];
            double ss = sumOfSquares[j2];
            j2 += w;
            while (j2 < end) {
                sum[j2] = s += sum[j2];
                sumOfSquares[j2] = ss += sumOfSquares[j2];
                j2 += w;
            }
            j2 -= n1;
        }
    }

    private static final void sumAndSumOfSquares(int width, int height, FloatProcessor fp1, double[] sum1, double[] sumOfSquares1, FloatProcessor fp2, double[] sum2, double[] sumOfSquares2) {
        int w = width + 1;
        int w1 = w + 1;
        int w2 = w + w;
        int n = w * height + w;
        int n1 = n - w1;
        int n2 = n1 - w + 2;
        int i = 0;
        int j = w1;
        while (j < n) {
            int end = i + width;
            double s1 = sum1[j] = (double)fp1.getf(i);
            double ss1 = sumOfSquares1[j] = s1 * s1;
            double s2 = sum2[j] = (double)fp2.getf(i);
            double ss2 = sumOfSquares2[j] = s2 * s2;
            ++i;
            ++j;
            while (i < end) {
                float a1 = fp1.getf(i);
                sum1[j] = s1 += (double)a1;
                sumOfSquares1[j] = ss1 += (double)(a1 * a1);
                float a2 = fp2.getf(i);
                sum2[j] = s2 += (double)a2;
                sumOfSquares2[j] = ss2 += (double)(a2 * a2);
                ++i;
                ++j;
            }
            ++j;
        }
        int j2 = w1;
        while (j2 < w2) {
            int end = j2 + n2;
            double s1 = sum1[j2];
            double ss1 = sumOfSquares1[j2];
            double s2 = sum2[j2];
            double ss2 = sumOfSquares2[j2];
            j2 += w;
            while (j2 < end) {
                sum1[j2] = s1 += sum1[j2];
                sumOfSquares1[j2] = ss1 += sumOfSquares1[j2];
                sum2[j2] = s2 += sum2[j2];
                sumOfSquares2[j2] = ss2 += sumOfSquares2[j2];
                j2 += w;
            }
            j2 -= n1;
        }
    }

    public BlockPMCC(int width, int height, FloatProcessor fpX, FloatProcessor fpY) {
        this.fpX = fpX;
        this.fpY = fpY;
        this.fpR = new FloatProcessor(width, height);
        double[] sumX = new double[(width + 1) * (height + 1)];
        double[] sumXX = new double[sumX.length];
        double[] sumY = new double[(width + 1) * (height + 1)];
        double[] sumYY = new double[sumY.length];
        double[] sumXY = new double[(width + 1) * (height + 1)];
        BlockPMCC.sumAndSumOfSquares(width, height, fpX, sumX, sumXX, fpY, sumY, sumYY);
        this.sumsX = new DoubleIntegralImage(sumX, width, height);
        this.sumsXX = new DoubleIntegralImage(sumXX, width, height);
        this.sumsY = new DoubleIntegralImage(sumY, width, height);
        this.sumsYY = new DoubleIntegralImage(sumYY, width, height);
        this.sumsXY = new DoubleIntegralImage(sumXY, width, height);
    }

    public BlockPMCC(int width, int height, FloatProcessor fpX, FloatProcessor fpY, int offsetX, int offsetY) {
        this(width, height, fpX, fpY);
        this.setOffset(offsetX, offsetY);
    }

    public BlockPMCC(FloatProcessor fpX, FloatProcessor fpY) {
        this.fpX = fpX;
        this.fpY = fpY;
        int widthX = fpX.getWidth();
        int heightX = fpX.getHeight();
        int widthY = fpY.getWidth();
        int heightY = fpY.getHeight();
        int widthXY = widthX < widthY ? widthX : widthY;
        int heightXY = heightX < heightY ? heightX : heightY;
        this.fpR = new FloatProcessor(widthY, heightY);
        double[] sumX = new double[(widthX + 1) * (heightX + 1)];
        double[] sumXX = new double[sumX.length];
        double[] sumY = new double[(widthY + 1) * (heightY + 1)];
        double[] sumYY = new double[sumY.length];
        double[] sumXY = new double[(widthXY + 1) * (heightXY + 1)];
        BlockPMCC.sumAndSumOfSquares(fpX, sumX, sumXX);
        BlockPMCC.sumAndSumOfSquares(fpY, sumY, sumYY);
        this.sumsX = new DoubleIntegralImage(sumX, widthX, heightX);
        this.sumsXX = new DoubleIntegralImage(sumXX, widthX, heightX);
        this.sumsY = new DoubleIntegralImage(sumY, widthY, heightY);
        this.sumsYY = new DoubleIntegralImage(sumYY, widthY, heightY);
        this.sumsXY = new DoubleIntegralImage(sumXY, widthXY, heightXY);
    }

    public BlockPMCC(FloatProcessor fpX, FloatProcessor fpY, int offsetX, int offsetY) {
        this(fpX, fpY);
        this.setOffset(offsetX, offsetY);
    }

    public final FloatProcessor getTargetProcessor() {
        return this.fpR;
    }

    public final void setOffset(int offsetX, int offsetY) {
        int b;
        int a;
        int fpXWidth = this.fpX.getWidth();
        int fpYWidth = this.fpY.getWidth();
        if (offsetX < 0) {
            this.offsetXX = -offsetX;
            this.offsetXY = 0;
            a = this.fpX.getWidth() + offsetX;
            b = this.fpY.getWidth();
        } else {
            this.offsetXX = 0;
            this.offsetXY = offsetX;
            a = this.fpX.getWidth();
            b = this.fpY.getWidth() - offsetX;
        }
        int n = this.fpXYWidth = a < b ? a : b;
        if (offsetY < 0) {
            this.offsetYX = -offsetY;
            this.offsetYY = 0;
            a = this.fpX.getHeight() + offsetY;
            b = this.fpY.getHeight();
        } else {
            this.offsetYX = 0;
            this.offsetYY = offsetY;
            a = this.fpX.getHeight();
            b = this.fpY.getHeight() - offsetY;
        }
        this.fpXYHeight = a < b ? a : b;
        int w = this.fpR.getWidth() + 1;
        int w1 = w + 1;
        double[] sum = this.sumsXY.getData();
        double s = 0.0;
        int x = 0;
        while (x < this.fpXYWidth) {
            float vX = this.fpX.getf(this.offsetYX * fpXWidth + x + this.offsetXX);
            float vY = this.fpY.getf(this.offsetYY * fpYWidth + x + this.offsetXY);
            sum[++x + w] = s += (double)(vX * vY);
        }
        int y = 1;
        while (y < this.fpXYHeight) {
            int rowX = (y + this.offsetYX) * fpXWidth;
            int rowY = (y + this.offsetYY) * fpYWidth;
            float vX = this.fpX.getf(rowX + this.offsetXX);
            float vY = this.fpY.getf(rowY + this.offsetXY);
            int yw = y * w + w1;
            sum[yw] = sum[yw - w] + (double)(vX * vY);
            int x2 = 1;
            while (x2 < this.fpXYWidth) {
                int ywx = yw + x2;
                vX = this.fpX.getf(rowX + x2 + this.offsetXX);
                vY = this.fpY.getf(rowY + x2 + this.offsetXY);
                sum[ywx] = sum[ywx - w] + sum[ywx - 1] + (double)(vX * vY) - sum[ywx - w - 1];
                ++x2;
            }
            ++y;
        }
    }

    public final void r(int blockRadiusX, int blockRadiusY) {
        int width = this.fpR.getWidth();
        int w = this.fpXYWidth - 1;
        int h = this.fpXYHeight - 1;
        int y = 0;
        while (y <= h) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int yMinX = yMin + this.offsetYX;
            int yMaxX = yMax + this.offsetYX;
            int yMinY = yMin + this.offsetYY;
            int yMaxY = yMax + this.offsetYY;
            int bh = yMax - yMin;
            int x = 0;
            while (x <= w) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                int xMinX = xMin + this.offsetXX;
                int xMaxX = xMax + this.offsetXX;
                int xMinY = xMin + this.offsetXY;
                int xMaxY = xMax + this.offsetXY;
                int n = (xMax - xMin) * bh;
                double sumX = this.sumsX.getDoubleSum(xMinX, yMinX, xMaxX, yMaxX);
                double sumXX = this.sumsXX.getDoubleSum(xMinX, yMinX, xMaxX, yMaxX);
                double sumY = this.sumsY.getDoubleSum(xMinY, yMinY, xMaxY, yMaxY);
                double sumYY = this.sumsYY.getDoubleSum(xMinY, yMinY, xMaxY, yMaxY);
                double sumXY = this.sumsXY.getDoubleSum(xMin, yMin, xMax, yMax);
                double a = (double)n * sumXY - sumX * sumY;
                double b = Math.sqrt((double)n * sumXX - sumX * sumX) * Math.sqrt((double)n * sumYY - sumY * sumY);
                this.fpR.setf(row + x, (float)(a / b));
                ++x;
            }
            ++y;
        }
    }

    public final void r(int blockRadius) {
        this.r(blockRadius, blockRadius);
    }

    public final void rSignedSquare(int blockRadiusX, int blockRadiusY) {
        int width = this.fpR.getWidth();
        int w = this.fpXYWidth - 1;
        int h = this.fpXYHeight - 1;
        int y = 0;
        while (y <= h) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int yMinX = yMin + this.offsetYX;
            int yMaxX = yMax + this.offsetYX;
            int yMinY = yMin + this.offsetYY;
            int yMaxY = yMax + this.offsetYY;
            int bh = yMax - yMin;
            int x = 0;
            while (x <= w) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                int xMinX = xMin + this.offsetXX;
                int xMaxX = xMax + this.offsetXX;
                int xMinY = xMin + this.offsetXY;
                int xMaxY = xMax + this.offsetXY;
                int n = (xMax - xMin) * bh;
                double sumX = this.sumsX.getDoubleSum(xMinX, yMinX, xMaxX, yMaxX);
                double sumXX = this.sumsXX.getDoubleSum(xMinX, yMinX, xMaxX, yMaxX);
                double sumY = this.sumsY.getDoubleSum(xMinY, yMinY, xMaxY, yMaxY);
                double sumYY = this.sumsYY.getDoubleSum(xMinY, yMinY, xMaxY, yMaxY);
                double sumXY = this.sumsXY.getDoubleSum(xMin, yMin, xMax, yMax);
                double a = (double)n * sumXY - sumX * sumY;
                double b = ((double)n * sumXX - sumX * sumX) * ((double)n * sumYY - sumY * sumY);
                if (a < 0.0) {
                    this.fpR.setf(row + x, (float)(-a * a / b));
                } else {
                    this.fpR.setf(row + x, (float)(a * a / b));
                }
                ++x;
            }
            ++y;
        }
    }

    public final void rSignedSquare(int blockRadius) {
        this.rSignedSquare(blockRadius, blockRadius);
    }
}

