/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import java.awt.Canvas;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class AbstractInteractiveBlockFilter
implements KeyListener,
MouseListener,
MouseMotionListener,
PlugIn {
    protected static final String NL = System.getProperty("line.separator");
    protected int blockRadiusX = 0;
    protected int blockRadiusY = 0;
    protected ImageJ ij;
    protected ImagePlus imp;
    protected ImageWindow window;
    protected Canvas canvas;
    protected PaintThread painter;

    protected abstract void showHelp();

    protected abstract void init();

    protected abstract void draw();

    public void run(String arg) {
        this.ij = IJ.getInstance();
        this.imp = IJ.getImage();
        this.window = this.imp.getWindow();
        this.canvas = this.imp.getCanvas();
        this.canvas.addKeyListener(this);
        this.window.addKeyListener((KeyListener)this);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addMouseListener(this);
        this.ij.addKeyListener((KeyListener)this);
        this.init();
        this.imp.getProcessor().snapshot();
        Toolbar.getInstance().setTool(0);
        this.painter = new PaintThread();
        this.painter.start();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            this.canvas.removeKeyListener(this);
            this.window.removeKeyListener((KeyListener)this);
            this.ij.removeKeyListener((KeyListener)this);
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            if (this.imp != null) {
                if (e.getKeyCode() == 27) {
                    this.imp.getProcessor().reset();
                } else {
                    e.getKeyCode();
                }
            }
            this.imp.updateAndDraw();
        } else if (e.getKeyCode() == 112) {
            this.showHelp();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle bounds = this.imp.getRoi().getBounds();
            this.blockRadiusX = bounds.width / 2;
            this.blockRadiusY = bounds.height / 2;
        } else {
            this.blockRadiusX = 0;
            this.blockRadiusY = 0;
        }
        this.painter.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDragged(e);
    }

    protected class PaintThread
    extends Thread {
        private boolean pleaseRepaint;

        PaintThread() {
            this.setName("MappingThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                boolean b;
                PaintThread paintThread = this;
                synchronized (paintThread) {
                    b = this.pleaseRepaint;
                    this.pleaseRepaint = false;
                }
                if (b) {
                    AbstractInteractiveBlockFilter.this.draw();
                    AbstractInteractiveBlockFilter.this.imp.updateAndDraw();
                }
                paintThread = this;
                synchronized (paintThread) {
                    try {
                        if (!this.pleaseRepaint) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint() {
            PaintThread paintThread = this;
            synchronized (paintThread) {
                this.pleaseRepaint = true;
                this.notify();
            }
        }
    }
}

