/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

public class Util {
    private static final void clipHistogram(int[] hist, int[] clippedHist, int limit) {
        int clippedEntriesBefore;
        System.arraycopy(hist, 0, clippedHist, 0, hist.length);
        int clippedEntries = 0;
        do {
            clippedEntriesBefore = clippedEntries;
            clippedEntries = 0;
            int i = 0;
            while (i < hist.length) {
                int d = clippedHist[i] - limit;
                if (d > 0) {
                    clippedEntries += d;
                    clippedHist[i] = limit;
                }
                ++i;
            }
            int d = clippedEntries / hist.length;
            int m = clippedEntries % hist.length;
            int i2 = 0;
            while (i2 < hist.length) {
                int n = i2++;
                clippedHist[n] = clippedHist[n] + d;
            }
            if (m == 0) continue;
            int s = (hist.length - 1) / m;
            int i3 = s / 2;
            while (i3 < hist.length) {
                int n = i3;
                clippedHist[n] = clippedHist[n] + 1;
                i3 += s;
            }
        } while (clippedEntries != clippedEntriesBefore);
    }

    static final float[] createTransfer(int[] hist, int limit) {
        int[] cdfs = new int[hist.length];
        Util.clipHistogram(hist, cdfs, limit);
        int hMin = hist.length - 1;
        int i = 0;
        while (i < hMin) {
            if (cdfs[i] != 0) {
                hMin = i;
            }
            ++i;
        }
        int cdf = 0;
        int i2 = hMin;
        while (i2 < hist.length) {
            cdfs[i2] = cdf += cdfs[i2];
            ++i2;
        }
        int cdfMin = cdfs[hMin];
        int cdfMax = cdfs[hist.length - 1];
        float[] transfer = new float[hist.length];
        int i3 = 0;
        while (i3 < transfer.length) {
            transfer[i3] = (float)(cdfs[i3] - cdfMin) / (float)(cdfMax - cdfMin);
            ++i3;
        }
        return transfer;
    }

    public static final float transferValue(int v, int[] clippedHist) {
        int hMin = clippedHist.length - 1;
        int i = 0;
        while (i < hMin) {
            if (clippedHist[i] != 0) {
                hMin = i;
            }
            ++i;
        }
        int cdf = 0;
        int i2 = hMin;
        while (i2 <= v) {
            cdf += clippedHist[i2];
            ++i2;
        }
        int cdfMax = cdf;
        int i3 = v + 1;
        while (i3 < clippedHist.length) {
            cdfMax += clippedHist[i3];
            ++i3;
        }
        int cdfMin = clippedHist[hMin];
        return (float)(cdf - cdfMin) / (float)(cdfMax - cdfMin);
    }

    public static final float transferValue(int v, int[] hist, int[] clippedHist, int limit) {
        Util.clipHistogram(hist, clippedHist, limit);
        return Util.transferValue(v, clippedHist);
    }
}

