/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.InvertibleTransformMapping;
import mpicbg.models.AffineModel2D;
import mpicbg.models.PointMatch;
import mpicbg.models.TransformMesh;
import mpicbg.util.Util;

public class TransformMeshMapping<T extends TransformMesh>
extends InvertibleTransformMapping<T> {
    public TransformMeshMapping(T t) {
        super(t);
    }

    protected static final void calculateBoundingBox(ArrayList<PointMatch> pm, float[] min, float[] max) {
        float[] first = pm.get(0).getP2().getW();
        min[0] = first[0];
        min[1] = first[1];
        max[0] = first[0];
        max[1] = first[1];
        for (PointMatch p : pm) {
            float[] t = p.getP2().getW();
            if (t[0] < min[0]) {
                min[0] = t[0];
            } else if (t[0] > max[0]) {
                max[0] = t[0];
            }
            if (t[1] < min[1]) {
                min[1] = t[1];
                continue;
            }
            if (!(t[1] > max[1])) continue;
            max[1] = t[1];
        }
    }

    protected static final boolean isInTriangle(float ax, float ay, float bx, float by, float cx, float cy, float tx, float ty) {
        float x1 = bx - ax;
        float y2 = ty - ay;
        float y1 = by - ay;
        float x2 = tx - ax;
        boolean d = x1 * y2 - y1 * x2 < 0.0f;
        if (d ^ (x1 = cx - bx) * (y2 = ty - by) - (y1 = cy - by) * (x2 = tx - bx) < 0.0f) {
            return false;
        }
        x1 = ax - cx;
        y2 = ty - cy;
        y1 = ay - cy;
        x2 = tx - cx;
        return !(d ^ x1 * y2 - y1 * x2 < 0.0f);
    }

    protected static final void mapTriangle(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        float[] min = new float[2];
        float[] max = new float[2];
        TransformMeshMapping.calculateBoundingBox(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        float[] a = pm.get(0).getP2().getW();
        float ax = a[0];
        float ay = a[1];
        float[] b = pm.get(1).getP2().getW();
        float bx = b[0];
        float by = b[1];
        float[] c = pm.get(2).getP2().getW();
        float cx = c[0];
        float cy = c[1];
        float[] t = new float[2];
        int y = minY;
        while (y <= maxY) {
            int x = minX;
            while (x <= maxX) {
                block5: {
                    if (TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) {
                        t[0] = x;
                        t[1] = y;
                        try {
                            ai.applyInverseInPlace(t);
                        }
                        catch (Exception e) {
                            break block5;
                        }
                        target.putPixel(x, y, source.getPixel((int)(t[0] + 0.5f), (int)(t[1] + 0.5f)));
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    protected static final void mapTriangleInterpolated(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        float[] min = new float[2];
        float[] max = new float[2];
        TransformMeshMapping.calculateBoundingBox(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        float[] a = pm.get(0).getP2().getW();
        float ax = a[0];
        float ay = a[1];
        float[] b = pm.get(1).getP2().getW();
        float bx = b[0];
        float by = b[1];
        float[] c = pm.get(2).getP2().getW();
        float cx = c[0];
        float cy = c[1];
        float[] t = new float[2];
        int y = minY;
        while (y <= maxY) {
            int x = minX;
            while (x <= maxX) {
                block5: {
                    if (TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) {
                        t[0] = x;
                        t[1] = y;
                        try {
                            ai.applyInverseInPlace(t);
                        }
                        catch (Exception e) {
                            break block5;
                        }
                        target.putPixel(x, y, source.getPixelInterpolated((double)t[0], (double)t[1]));
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void map(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangle((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            void var7_11;
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<MapTriangleThread> threads = new ArrayList<MapTriangleThread>(numThreads);
            boolean bl = false;
            while (var7_11 < numThreads) {
                MapTriangleThread mtt = new MapTriangleThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
                ++var7_11;
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final void map(ImageProcessor source, ImageProcessor target) {
        this.map(source, target, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - void declaration
     */
    public final void mapInterpolated(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangleInterpolated((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            void var7_11;
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<MapTriangleInterpolatedThread> threads = new ArrayList<MapTriangleInterpolatedThread>(numThreads);
            boolean bl = false;
            while (var7_11 < numThreads) {
                MapTriangleInterpolatedThread mtt = new MapTriangleInterpolatedThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
                ++var7_11;
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final void mapInterpolated(ImageProcessor source, ImageProcessor target) {
        this.mapInterpolated(source, target, Runtime.getRuntime().availableProcessors());
    }

    protected static final void calculateBoundingBoxInverse(ArrayList<PointMatch> pm, float[] min, float[] max) {
        float[] first = pm.get(0).getP1().getL();
        min[0] = first[0];
        min[1] = first[1];
        max[0] = first[0];
        max[1] = first[1];
        for (PointMatch p : pm) {
            float[] t = p.getP1().getL();
            if (t[0] < min[0]) {
                min[0] = t[0];
            } else if (t[0] > max[0]) {
                max[0] = t[0];
            }
            if (t[1] < min[1]) {
                min[1] = t[1];
                continue;
            }
            if (!(t[1] > max[1])) continue;
            max[1] = t[1];
        }
    }

    protected static final void mapTriangleInverse(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        float[] min = new float[2];
        float[] max = new float[2];
        TransformMeshMapping.calculateBoundingBoxInverse(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        float[] a = pm.get(0).getP1().getL();
        float ax = a[0];
        float ay = a[1];
        float[] b = pm.get(1).getP1().getL();
        float bx = b[0];
        float by = b[1];
        float[] c = pm.get(2).getP1().getL();
        float cx = c[0];
        float cy = c[1];
        float[] t = new float[2];
        int y = minY;
        while (y <= maxY) {
            int x = minX;
            while (x <= maxX) {
                if (TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) {
                    t[0] = x;
                    t[1] = y;
                    ai.applyInPlace(t);
                    target.putPixel(x, y, source.getPixel((int)(t[0] + 0.5f), (int)(t[1] + 0.5f)));
                }
                ++x;
            }
            ++y;
        }
    }

    protected static final void mapTriangleInverseInterpolated(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList<PointMatch> pm = m.getAV().get(ai);
        float[] min = new float[2];
        float[] max = new float[2];
        TransformMeshMapping.calculateBoundingBoxInverse(pm, min, max);
        int minX = Math.max(0, Util.roundPos(min[0]));
        int minY = Math.max(0, Util.roundPos(min[1]));
        int maxX = Math.min(w, Util.roundPos(max[0]));
        int maxY = Math.min(h, Util.roundPos(max[1]));
        float[] a = pm.get(0).getP1().getL();
        float ax = a[0];
        float ay = a[1];
        float[] b = pm.get(1).getP1().getL();
        float bx = b[0];
        float by = b[1];
        float[] c = pm.get(2).getP1().getL();
        float cx = c[0];
        float cy = c[1];
        float[] t = new float[2];
        int y = minY;
        while (y <= maxY) {
            int x = minX;
            while (x <= maxX) {
                if (TransformMeshMapping.isInTriangle(ax, ay, bx, by, cx, cy, x, y)) {
                    t[0] = x;
                    t[1] = y;
                    ai.applyInPlace(t);
                    target.putPixel(x, y, source.getPixelInterpolated((double)t[0], (double)t[1]));
                }
                ++x;
            }
            ++y;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void mapInverse(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangleInverse((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            void var7_11;
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<MapTriangleInverseThread> threads = new ArrayList<MapTriangleInverseThread>(numThreads);
            boolean bl = false;
            while (var7_11 < numThreads) {
                MapTriangleInverseThread mtt = new MapTriangleInverseThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
                ++var7_11;
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final void mapInverse(ImageProcessor source, ImageProcessor target) {
        this.mapInverse(source, target, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - void declaration
     */
    public final void mapInverseInterpolated(ImageProcessor source, ImageProcessor target, int numThreads) {
        if (numThreads == 1) {
            Set<AffineModel2D> s = ((TransformMesh)this.transform).getAV().keySet();
            for (AffineModel2D ai : s) {
                TransformMeshMapping.mapTriangleInverseInterpolated((TransformMesh)this.transform, ai, source, target);
            }
        } else {
            void var7_11;
            ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
            l.addAll(((TransformMesh)this.transform).getAV().keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<MapTriangleInverseInterpolatedThread> threads = new ArrayList<MapTriangleInverseInterpolatedThread>(numThreads);
            boolean bl = false;
            while (var7_11 < numThreads) {
                MapTriangleInverseInterpolatedThread mtt = new MapTriangleInverseInterpolatedThread(i, l, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
                ++var7_11;
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final void mapInverseInterpolated(ImageProcessor source, ImageProcessor target) {
        this.mapInverseInterpolated(source, target, Runtime.getRuntime().availableProcessors());
    }

    private static final class MapTriangleInterpolatedThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleInterpolatedThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangleInterpolated(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapTriangleInverseInterpolatedThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleInverseInterpolatedThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangleInverseInterpolated(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapTriangleInverseThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleInverseThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangleInverse(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapTriangleThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessor source;
        final ImageProcessor target;

        MapTriangleThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessor source, ImageProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMapping.mapTriangle(this.transform, this.triangles.get(k), this.source, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }
}

