/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import mpicbg.ij.InverseMapping;
import mpicbg.models.CoordinateTransform;

public class TransformMapping<T extends CoordinateTransform>
implements InverseMapping<T> {
    protected final T transform;

    @Override
    public final T getTransform() {
        return this.transform;
    }

    public TransformMapping(T t) {
        this.transform = t;
    }

    @Override
    public void mapInverse(ImageProcessor source, ImageProcessor target) {
        float[] t = new float[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        int y = 0;
        while (y < th) {
            int x = 0;
            while (x < tw) {
                t[0] = x;
                t[1] = y;
                this.transform.applyInPlace(t);
                int tx = (int)(t[0] + 0.5f);
                int ty = (int)(t[1] + 0.5f);
                if (t[0] >= 0.0f && t[0] <= (float)sw && t[1] >= 0.0f && t[1] <= (float)sh) {
                    target.putPixel(x, y, source.getPixel(tx, ty));
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void mapInverseInterpolated(ImageProcessor source, ImageProcessor target) {
        float[] t = new float[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        int y = 0;
        while (y < th) {
            int x = 0;
            while (x < tw) {
                t[0] = x;
                t[1] = y;
                this.transform.applyInPlace(t);
                if (t[0] >= 0.0f && t[0] <= (float)sw && t[1] >= 0.0f && t[1] <= (float)sh) {
                    target.putPixel(x, y, source.getPixelInterpolated((double)t[0], (double)t[1]));
                }
                ++x;
            }
            ++y;
        }
    }
}

