/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.gui.GenericDialog;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.Collection;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.util.Filter;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.imagefeatures.ImageArrayConverter;

public class SIFT
extends FeatureTransform<FloatArray2DSIFT> {
    public SIFT(FloatArray2DSIFT t) {
        super(t);
    }

    public static final void addFields(GenericDialog gd, FloatArray2DSIFT.Param p) {
        gd.addMessage("Scale Invariant Interest Point Detector:");
        gd.addNumericField("initial_gaussian_blur :", (double)p.initialSigma, 2, 6, "px");
        gd.addNumericField("steps_per_scale_octave :", (double)p.steps, 0);
        gd.addNumericField("minimum_image_size :", (double)p.minOctaveSize, 0, 6, "px");
        gd.addNumericField("maximum_image_size :", (double)p.maxOctaveSize, 0, 6, "px");
        gd.addMessage("Feature Descriptor:");
        gd.addNumericField("feature_descriptor_size :", (double)p.fdSize, 0);
        gd.addNumericField("feature_descriptor_orientation_bins :", (double)p.fdBins, 0);
    }

    public static final void readFields(GenericDialog gd, FloatArray2DSIFT.Param p) {
        p.initialSigma = (float)gd.getNextNumber();
        p.steps = (int)gd.getNextNumber();
        p.minOctaveSize = (int)gd.getNextNumber();
        p.maxOctaveSize = (int)gd.getNextNumber();
        p.fdSize = (int)gd.getNextNumber();
        p.fdBins = (int)gd.getNextNumber();
    }

    @Override
    public final void extractFeatures(ImageProcessor ip, Collection<Feature> features) {
        float[] initialKernel;
        FloatArray2D fa;
        float maxSize = ((FloatArray2DSIFT)this.t).getMaxOctaveSize() - 1;
        float scale = 1.0f;
        if (maxSize < (float)ip.getWidth() || maxSize < (float)ip.getHeight()) {
            scale = Math.min(maxSize / (float)ip.getWidth(), maxSize / (float)ip.getHeight());
            FloatProcessor fp = (FloatProcessor)ip.convertToFloat();
            fp.setMinAndMax(ip.getMin(), ip.getMax());
            FloatProcessor ipScaled = Filter.createDownsampled(fp, scale, 0.5f, 0.5f);
            fa = new FloatArray2D(ipScaled.getWidth(), ipScaled.getHeight());
            ImageArrayConverter.imageProcessorToFloatArray2DCropAndNormalize((ImageProcessor)ipScaled, fa);
        } else {
            fa = new FloatArray2D(ip.getWidth(), ip.getHeight());
            ImageArrayConverter.imageProcessorToFloatArray2DCropAndNormalize(ip, fa);
        }
        float initialSigma = ((FloatArray2DSIFT)this.t).getInitialSigma();
        if ((double)initialSigma < 1.0) {
            scale *= 2.0f;
            ((FloatArray2DSIFT)this.t).setInitialSigma(initialSigma * 2.0f);
            FloatArray2D fat = new FloatArray2D(fa.width * 2 - 1, fa.height * 2 - 1);
            FloatArray2DScaleOctave.upsample(fa, fat);
            fa = fat;
            initialKernel = mpicbg.imagefeatures.Filter.createGaussianKernel((float)Math.sqrt((double)(((FloatArray2DSIFT)this.t).getInitialSigma() * ((FloatArray2DSIFT)this.t).getInitialSigma()) - 1.0), true);
        } else {
            initialKernel = mpicbg.imagefeatures.Filter.createGaussianKernel((float)Math.sqrt((double)(initialSigma * initialSigma) - 0.25), true);
        }
        fa = mpicbg.imagefeatures.Filter.convolveSeparable(fa, initialKernel, initialKernel);
        ((FloatArray2DSIFT)this.t).init(fa);
        ((FloatArray2DSIFT)this.t).extractFeatures(features);
        if (scale != 1.0f) {
            for (Feature f : features) {
                f.scale /= scale;
                f.location[0] = f.location[0] / scale;
                f.location[1] = f.location[1] / scale;
            }
            ((FloatArray2DSIFT)this.t).setInitialSigma(initialSigma);
        }
    }
}

