/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.process.ImageProcessor;
import java.awt.Cursor;
import java.util.concurrent.atomic.AtomicBoolean;
import mpicbg.ij.Mapping;

public class MappingThread
extends Thread {
    protected final ImagePlus imp;
    protected final ImageProcessor source;
    protected final ImageProcessor target;
    protected final ImageProcessor temp;
    protected final AtomicBoolean pleaseRepaint;
    protected final Mapping<?> mapping;
    protected final boolean interpolate;
    protected final int stackIndex;

    public MappingThread(ImagePlus imp, ImageProcessor source, ImageProcessor target, AtomicBoolean pleaseRepaint, Mapping<?> mapping, boolean interpolate, int stackIndex) {
        this.imp = imp;
        this.source = source;
        this.target = target;
        this.temp = target.createProcessor(target.getWidth(), target.getHeight());
        this.temp.snapshot();
        this.pleaseRepaint = pleaseRepaint;
        this.mapping = mapping;
        this.interpolate = interpolate;
        this.setName("MappingThread");
        this.stackIndex = stackIndex;
    }

    public MappingThread(ImagePlus imp, ImageProcessor source, ImageProcessor target, AtomicBoolean pleaseRepaint, Mapping<?> mapping, boolean interpolate) {
        this(imp, source, target, pleaseRepaint, mapping, interpolate, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ImageStack stack = this.imp.getStack();
        while (!this.isInterrupted()) {
            Cursor cursor;
            ImageCanvas canvas;
            block15: {
                canvas = this.imp.getCanvas();
                cursor = canvas == null ? Cursor.getDefaultCursor() : canvas.getCursor();
                try {
                    try {
                        Object targetPixels;
                        if (this.pleaseRepaint.getAndSet(false)) {
                            if (canvas != null) {
                                canvas.setCursor(Cursor.getPredefinedCursor(3));
                            }
                            this.temp.reset();
                            if (this.interpolate) {
                                this.mapping.mapInterpolated(this.source, this.temp);
                            } else {
                                this.mapping.map(this.source, this.temp);
                            }
                            if (!this.pleaseRepaint.get()) {
                                targetPixels = this.target.getPixels();
                                this.target.setPixels(this.temp.getPixels());
                                this.temp.setPixels(targetPixels);
                                if (this.stackIndex > 0 && this.imp.isComposite()) {
                                    CompositeImage cimp = (CompositeImage)this.imp;
                                    stack.setPixels(this.target.getPixels(), this.stackIndex);
                                    cimp.setChannelsUpdated();
                                }
                                this.imp.updateAndDraw();
                            }
                            break block15;
                        }
                        targetPixels = this;
                        synchronized (targetPixels) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (canvas == null) continue;
                        canvas.setCursor(cursor);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (canvas != null) {
                        canvas.setCursor(cursor);
                    }
                    throw throwable;
                }
            }
            if (canvas == null) continue;
            canvas.setCursor(cursor);
        }
    }
}

