/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import mpicbg.ij.Mapping;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class InverseTransformMapping<T extends InverseCoordinateTransform>
implements Mapping<T> {
    protected final T transform;

    @Override
    public final T getTransform() {
        return this.transform;
    }

    public InverseTransformMapping(T t) {
        this.transform = t;
    }

    @Override
    public void map(ImageProcessor source, ImageProcessor target) {
        float[] t = new float[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        int y = 0;
        while (y < th) {
            int x = 0;
            while (x < tw) {
                t[0] = x;
                t[1] = y;
                try {
                    this.transform.applyInverseInPlace(t);
                    int tx = (int)(t[0] + 0.5f);
                    int ty = (int)(t[1] + 0.5f);
                    if (tx >= 0 && tx <= sw && ty >= 0 && ty <= sh) {
                        target.putPixel(x, y, source.getPixel(tx, ty));
                    }
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void mapInterpolated(ImageProcessor source, ImageProcessor target) {
        float[] t = new float[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        int y = 0;
        while (y < th) {
            int x = 0;
            while (x < tw) {
                t[0] = x;
                t[1] = y;
                try {
                    this.transform.applyInverseInPlace(t);
                    if (t[0] >= 0.0f && t[0] <= (float)sw && t[1] >= 0.0f && t[1] <= (float)sh) {
                        target.putPixel(x, y, source.getPixelInterpolated((double)t[0], (double)t[1]));
                    }
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
                ++x;
            }
            ++y;
        }
    }
}

