/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import mpicbg.ij.Mapping;
import mpicbg.ij.MappingThread;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public abstract class InteractiveMapping
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ImageListener {
    protected ImagePlus imp;
    protected ImageProcessor target;
    protected ImageProcessor source;
    protected Point[] p;
    protected Point[] q;
    protected final ArrayList<PointMatch> m = new ArrayList();
    protected PointRoi handles;
    protected final ArrayList<Point> hooks = new ArrayList();
    protected Mapping<?> mapping;
    protected MappingThread painter;
    protected final AtomicBoolean pleaseRepaint = new AtomicBoolean(false);
    protected static boolean showIllustration = false;
    protected static boolean showPreview = false;
    protected int targetIndex = -1;
    protected static boolean interpolate;

    protected abstract void updateHandles(int var1, int var2);

    public void init() {
    }

    protected abstract void createMapping();

    protected abstract void updateMapping() throws NotEnoughDataPointsException, IllDefinedDataPointsException;

    protected abstract void addHandle(int var1, int var2);

    protected abstract void updateIllustration();

    public void run(String arg) {
        this.m.clear();
        this.imp = IJ.getImage();
        this.target = this.imp.getProcessor();
        this.source = this.target.duplicate();
        this.source.setInterpolationMethod(1);
        this.init();
        this.createMapping();
        this.painter = new MappingThread(this.imp, this.source, this.target, this.pleaseRepaint, this.mapping, interpolate);
        this.painter.start();
        Toolbar.getInstance().setTool(Toolbar.getInstance().addTool("Add_and_drag_handles."));
        this.imp.getCanvas().addMouseListener((MouseListener)this);
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.imp.getCanvas().addKeyListener((KeyListener)this);
        this.imp.getWindow().addKeyListener((KeyListener)this);
        IJ.getInstance().addKeyListener((KeyListener)this);
    }

    protected final void updateRoi() {
        int[] x = new int[this.hooks.size()];
        int[] y = new int[this.hooks.size()];
        int i = 0;
        while (i < this.hooks.size()) {
            float[] l = this.hooks.get(i).getW();
            x[i] = (int)l[0];
            y[i] = (int)l[1];
            ++i;
        }
        this.handles = new PointRoi(x, y, this.hooks.size());
        this.imp.setRoi((Roi)this.handles);
    }

    public void imageClosed(ImagePlus impl) {
        if (impl == this.imp) {
            this.painter.interrupt();
        }
    }

    public void imageOpened(ImagePlus impl) {
    }

    public void imageUpdated(ImagePlus impl) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            if (this.imp != null) {
                this.imp.getCanvas().removeMouseListener((MouseListener)this);
                this.imp.getCanvas().removeMouseMotionListener((MouseMotionListener)this);
                this.imp.getCanvas().removeKeyListener((KeyListener)this);
                this.imp.getWindow().removeKeyListener((KeyListener)this);
                IJ.getInstance().removeKeyListener((KeyListener)this);
                this.imp.setOverlay(null);
                this.imp.setRoi(null);
            }
            if (e.getKeyCode() == 27) {
                this.imp.setProcessor(null, this.source);
            } else {
                this.target.reset();
                this.mapping.mapInterpolated(this.source, this.target);
                this.imp.updateAndDraw();
            }
        } else if (e.getKeyCode() == 85) {
            showIllustration = !showIllustration;
            this.updateIllustration();
            e.consume();
        } else if (e.getKeyCode() == 112) {
            boolean cfr_ignored_0 = e.getSource() instanceof TextField;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.targetIndex = -1;
        ImageWindow win = WindowManager.getCurrentWindow();
        int xm = win.getCanvas().offScreenX(e.getX());
        int ym = win.getCanvas().offScreenY(e.getY());
        double target_d = Double.MAX_VALUE;
        int i = 0;
        while (i < this.hooks.size()) {
            double dy;
            float[] l = this.hooks.get(i).getW();
            double dx = win.getCanvas().getMagnification() * (double)(l[0] - (float)xm);
            double d = dx * dx + (dy = win.getCanvas().getMagnification() * (double)(l[1] - (float)ym)) * dy;
            if (d < 64.0 && d < target_d) {
                this.targetIndex = i;
                target_d = d;
            }
            ++i;
        }
        if (e.getButton() == 1 && this.targetIndex == -1) {
            this.addHandle(xm, ym);
            this.updateRoi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (!showPreview) {
            try {
                this.updateMapping();
                MappingThread mappingThread = this.painter;
                synchronized (mappingThread) {
                    this.pleaseRepaint.set(true);
                    this.painter.notify();
                }
            }
            catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            }
            catch (IllDefinedDataPointsException illDefinedDataPointsException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        block7: {
            if (this.targetIndex >= 0) {
                ImageWindow win = WindowManager.getCurrentWindow();
                int x = win.getCanvas().offScreenX(e.getX());
                int y = win.getCanvas().offScreenY(e.getY());
                this.updateHandles(x, y);
                this.updateIllustration();
                this.updateRoi();
                try {
                    this.updateMapping();
                    if (!showPreview) break block7;
                    MappingThread mappingThread = this.painter;
                    synchronized (mappingThread) {
                        this.pleaseRepaint.set(true);
                        this.painter.notify();
                    }
                }
                catch (NotEnoughDataPointsException notEnoughDataPointsException) {
                }
                catch (IllDefinedDataPointsException illDefinedDataPointsException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = String.valueOf(s) + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = String.valueOf(s) + "Control ";
        }
        if ((flags & 4) != 0) {
            s = String.valueOf(s) + "Meta (right button) ";
        }
        if ((flags & 8) != 0) {
            s = String.valueOf(s) + "Alt ";
        }
        if ((s = String.valueOf(s) + "]").equals(" [ ]")) {
            s = " [no modifiers]";
        }
        return s;
    }
}

