/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PointRoi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.ij.MappingThread;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public abstract class InteractiveInvertibleCoordinateTransform<M extends Model<M> & InvertibleCoordinateTransform>
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ImageListener {
    protected InverseTransformMapping<M> mapping;
    protected ImagePlus imp;
    protected final ArrayList<Tuple> tuples = new ArrayList();
    protected Point[] p;
    protected Point[] q;
    protected final ArrayList<PointMatch> m = new ArrayList();
    protected PointRoi handles;
    protected int targetIndex = -1;

    protected abstract M myModel();

    protected abstract void setHandles();

    protected abstract void updateHandles(int var1, int var2);

    public void run(String arg) {
        this.m.clear();
        this.tuples.clear();
        this.imp = IJ.getImage();
        if (this.imp.isComposite() && ((CompositeImage)this.imp).getMode() == 1) {
            int z = this.imp.getSlice();
            int t = this.imp.getFrame();
            int c = 1;
            while (c <= this.imp.getNChannels()) {
                int i = this.imp.getStackIndex(c, z, t);
                ImageProcessor target = this.imp.getStack().getProcessor(i);
                ImageProcessor source = target.duplicate();
                source.setInterpolationMethod(1);
                this.tuples.add(new Tuple(source, target));
                ++c;
            }
        } else {
            ImageProcessor target = this.imp.getProcessor();
            ImageProcessor source = target.duplicate();
            source.setInterpolationMethod(1);
            this.tuples.add(new Tuple(source, target));
        }
        this.mapping = new InverseTransformMapping<M>(this.myModel());
        for (Tuple tuple : this.tuples) {
            tuple.painter = new MappingThread(this.imp, tuple.source, tuple.target, tuple.pleaseRepaint, this.mapping, false, this.imp.getStackIndex(this.imp.getChannel(), this.imp.getSlice(), this.imp.getFrame()));
            tuple.painter.start();
        }
        this.setHandles();
        Toolbar.getInstance().setTool(Toolbar.getInstance().addTool("Drag_the_handles."));
        this.imp.getCanvas().addMouseListener((MouseListener)this);
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.imp.getCanvas().addKeyListener((KeyListener)this);
    }

    public void imageClosed(ImagePlus imp2) {
        if (imp2 == this.imp) {
            for (Tuple tuple : this.tuples) {
                tuple.painter.interrupt();
            }
        }
    }

    public void imageOpened(ImagePlus imp2) {
    }

    public void imageUpdated(ImagePlus imp2) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            for (Tuple tuple : this.tuples) {
                tuple.painter.interrupt();
            }
            if (this.imp != null) {
                this.imp.getCanvas().removeMouseListener((MouseListener)this);
                this.imp.getCanvas().removeMouseMotionListener((MouseMotionListener)this);
                this.imp.getCanvas().removeKeyListener((KeyListener)this);
                this.imp.getCanvas().setDisplayList(null);
                this.imp.setRoi(null);
            }
            int z = this.imp.getSlice();
            int t = this.imp.getFrame();
            if (this.imp.isComposite() && ((CompositeImage)this.imp).getMode() == 1) {
                int c = 1;
                while (c <= this.imp.getNChannels()) {
                    int i = this.imp.getStackIndex(c, z, t);
                    ImageProcessor ip = this.tuples.get((int)(c - 1)).source;
                    this.imp.getStack().setPixels(ip.getPixels(), i);
                    if (c == this.imp.getChannel()) {
                        this.imp.setProcessor(ip);
                    }
                    ++c;
                }
            } else {
                ImageProcessor ip = this.tuples.get((int)0).source;
                this.imp.setProcessor(ip);
                this.imp.getStack().setPixels(ip.getPixels(), this.imp.getStackIndex(this.imp.getChannel(), z, t));
            }
            if (e.getKeyCode() == 10) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int si = InteractiveInvertibleCoordinateTransform.this.imp.getStackIndex(InteractiveInvertibleCoordinateTransform.this.imp.getChannel(), InteractiveInvertibleCoordinateTransform.this.imp.getSlice(), InteractiveInvertibleCoordinateTransform.this.imp.getFrame());
                        ImageStack stack = InteractiveInvertibleCoordinateTransform.this.imp.getStack();
                        int i = 1;
                        while (i <= stack.getSize()) {
                            ImageProcessor source = stack.getProcessor(i).duplicate();
                            ImageProcessor target = source.createProcessor(source.getWidth(), source.getHeight());
                            source.setInterpolationMethod(1);
                            InteractiveInvertibleCoordinateTransform.this.mapping.mapInterpolated(source, target);
                            if (i == si) {
                                InteractiveInvertibleCoordinateTransform.this.imp.getProcessor().setPixels(target.getPixels());
                            }
                            stack.setPixels(target.getPixels(), i);
                            IJ.showProgress((int)i, (int)stack.getSize());
                            ++i;
                        }
                        if (InteractiveInvertibleCoordinateTransform.this.imp.isComposite()) {
                            ((CompositeImage)InteractiveInvertibleCoordinateTransform.this.imp).setChannelsUpdated();
                        }
                        InteractiveInvertibleCoordinateTransform.this.imp.updateAndDraw();
                    }
                });
                thread.start();
            }
        } else if (e.getKeyCode() == 112) {
            boolean cfr_ignored_0 = e.getSource() instanceof TextField;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.targetIndex = -1;
        if (e.getButton() == 1) {
            ImageWindow win = WindowManager.getCurrentWindow();
            int x = win.getCanvas().offScreenX(e.getX());
            int y = win.getCanvas().offScreenY(e.getY());
            double target_d = Double.MAX_VALUE;
            int i = 0;
            while (i < this.q.length) {
                double dy;
                double dx = win.getCanvas().getMagnification() * (double)(this.q[i].getW()[0] - (float)x);
                double d = dx * dx + (dy = win.getCanvas().getMagnification() * (double)(this.q[i].getW()[1] - (float)y)) * dy;
                if (d < 64.0 && d < target_d) {
                    this.targetIndex = i;
                    target_d = d;
                }
                ++i;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.targetIndex >= 0) {
            ImageWindow win = WindowManager.getCurrentWindow();
            int x = win.getCanvas().offScreenX(e.getX());
            int y = win.getCanvas().offScreenY(e.getY());
            this.updateHandles(x, y);
            try {
                this.myModel().fit(this.m);
                for (Tuple tuple : this.tuples) {
                    MappingThread mappingThread = tuple.painter;
                    synchronized (mappingThread) {
                        tuple.pleaseRepaint.set(true);
                        tuple.painter.notify();
                    }
                }
            }
            catch (NotEnoughDataPointsException ex) {
                ex.printStackTrace();
            }
            catch (IllDefinedDataPointsException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = String.valueOf(s) + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = String.valueOf(s) + "Control ";
        }
        if ((flags & 4) != 0) {
            s = String.valueOf(s) + "Meta (right button) ";
        }
        if ((flags & 8) != 0) {
            s = String.valueOf(s) + "Alt ";
        }
        if ((s = String.valueOf(s) + "]").equals(" [ ]")) {
            s = " [no modifiers]";
        }
        return s;
    }

    public static class Tuple {
        public final ImageProcessor source;
        public final ImageProcessor target;
        public final AtomicBoolean pleaseRepaint = new AtomicBoolean(false);
        public MappingThread painter = null;

        Tuple(ImageProcessor source, ImageProcessor target) {
            this.source = source;
            this.target = target;
        }
    }
}

