/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DFeatureTransform;
import mpicbg.imagefeatures.ImageArrayConverter;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public abstract class FeatureTransform<T extends FloatArray2DFeatureTransform<?>> {
    protected final T t;

    public FeatureTransform(T t) {
        this.t = t;
    }

    public void extractFeatures(ImageProcessor ip, Collection<Feature> features) {
        FloatArray2D fa = new FloatArray2D(ip.getWidth(), ip.getHeight());
        ImageArrayConverter.imageProcessorToFloatArray2DCropAndNormalize(ip, fa);
        ((FloatArray2DFeatureTransform)this.t).init(fa);
    }

    public final Collection<Feature> extractFeatures(ImageProcessor ip) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        this.extractFeatures(ip, features);
        return features;
    }

    public static void matchFeatures(Collection<Feature> fs1, Collection<Feature> fs2, List<PointMatch> matches, float rod) {
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            for (Feature f2 : fs2) {
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.add(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]})));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
    }
}

