/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.egl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.egl.EGL;
import com.sun.opengl.impl.egl.EGLDrawableFactory;
import com.sun.opengl.impl.egl.EGLDynamicLookupHelper;
import com.sun.opengl.impl.egl.EGLGraphicsConfiguration;
import com.sun.opengl.impl.egl._EGLConfig;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public abstract class EGLDrawable
extends GLDrawableImpl {
    protected boolean ownEGLDisplay = false;
    protected boolean ownEGLSurface = false;
    private EGLGraphicsConfiguration eglConfig;
    protected long eglDisplay = 0L;
    protected long eglSurface = 0L;

    protected EGLDrawable(EGLDrawableFactory eGLDrawableFactory, NativeWindow nativeWindow) throws GLException {
        super((GLDrawableFactory)eGLDrawableFactory, nativeWindow, false);
    }

    public long getDisplay() {
        return this.eglDisplay;
    }

    public long getSurface() {
        return this.eglSurface;
    }

    public EGLGraphicsConfiguration getGraphicsConfiguration() {
        return this.eglConfig;
    }

    public GLCapabilities getChosenGLCapabilities() {
        return null == this.eglConfig ? super.getChosenGLCapabilities() : (GLCapabilities)this.eglConfig.getChosenCapabilities();
    }

    public abstract GLContext createContext(GLContext var1);

    protected abstract long createSurface(long var1, _EGLConfig var3);

    private void recreateSurface() {
        if (this.ownEGLSurface) {
            if (0L != this.eglSurface) {
                EGL.eglDestroySurface(this.eglDisplay, this.eglSurface);
            }
            this.eglSurface = this.createSurface(this.eglDisplay, this.eglConfig.getNativeConfig());
            if (DEBUG) {
                System.err.println("setSurface using component: handle 0x" + Long.toHexString(this.component.getWindowHandle()) + " -> 0x" + Long.toHexString(this.eglSurface));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRealized(boolean bl) {
        super.setRealized(bl);
        if (bl) {
            if (1 == this.lockSurface()) {
                throw new GLException("Couldn't lock surface");
            }
            try {
                AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.component.getGraphicsConfiguration().getNativeGraphicsConfiguration();
                AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
                if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
                    this.eglDisplay = abstractGraphicsDevice.getHandle();
                    if (this.eglDisplay == 0L) {
                        throw new GLException("Invalid EGL display in EGLGraphicsDevice from " + abstractGraphicsDevice);
                    }
                    if (!(abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration)) throw new GLException("EGLGraphicsConfiguration doesn't carry a EGLGraphicsDevice: " + abstractGraphicsConfiguration);
                    this.eglConfig = (EGLGraphicsConfiguration)abstractGraphicsConfiguration;
                    if (null == this.eglConfig) {
                        throw new GLException("Null EGLGraphicsConfiguration from " + abstractGraphicsConfiguration);
                    }
                    int[] nArray = new int[1];
                    if (EGL.eglQuerySurface(this.eglDisplay, this.component.getWindowHandle(), 12328, nArray, 0)) {
                        this.eglSurface = this.component.getWindowHandle();
                        if (DEBUG) {
                            System.err.println("setSurface re-using component's EGLSurface: handle 0x" + Long.toHexString(this.eglSurface));
                        }
                    } else {
                        this.ownEGLSurface = true;
                        this.eglConfig.updateGraphicsConfiguration();
                    }
                } else {
                    this.ownEGLDisplay = true;
                    this.ownEGLSurface = true;
                    long l = "Windows".equals(NativeWindowFactory.getNativeWindowType((boolean)false)) ? this.component.getSurfaceHandle() : abstractGraphicsDevice.getHandle();
                    this.eglDisplay = EGL.eglGetDisplay(l);
                    if (this.eglDisplay == 0L) {
                        if (DEBUG) {
                            System.err.println("eglDisplay(" + Long.toHexString(l) + " <surfaceHandle>): failed, using EGL_DEFAULT_DISPLAY");
                        }
                        l = 0L;
                        this.eglDisplay = EGL.eglGetDisplay(l);
                    }
                    if (this.eglDisplay == 0L) {
                        throw new GLException("Failed to created EGL display: nhandle 0x" + Long.toHexString(l) + ", " + abstractGraphicsDevice + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
                    }
                    if (DEBUG) {
                        System.err.println("eglDisplay(" + Long.toHexString(l) + "): 0x" + Long.toHexString(this.eglDisplay));
                    }
                    if (!EGL.eglInitialize(this.eglDisplay, null, null)) {
                        throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
                    }
                    EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(this.eglDisplay);
                    DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
                    GLCapabilities gLCapabilities = (GLCapabilities)abstractGraphicsConfiguration.getChosenCapabilities();
                    this.eglConfig = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)eGLGraphicsDevice).chooseGraphicsConfiguration((Capabilities)gLCapabilities, null, (AbstractGraphicsScreen)defaultGraphicsScreen);
                    if (null == this.eglConfig) {
                        throw new GLException("Couldn't create EGLGraphicsConfiguration from " + defaultGraphicsScreen);
                    }
                    if (DEBUG) {
                        System.err.println("Chosen eglConfig: " + this.eglConfig);
                    }
                }
                this.recreateSurface();
                return;
            }
            finally {
                this.unlockSurface();
            }
        } else {
            if (!this.ownEGLSurface || this.eglSurface == 0L) return;
            if (!EGL.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
                throw new GLException("Error destroying window surface (eglDestroySurface)");
            }
            this.eglSurface = 0L;
            if (this.ownEGLDisplay && 0L != this.eglDisplay) {
                EGL.eglTerminate(this.eglDisplay);
            }
            this.eglDisplay = 0L;
            this.eglConfig = null;
        }
    }

    public int getWidth() {
        int[] nArray = new int[1];
        if (!EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray, 0)) {
            throw new GLException("Error querying surface width");
        }
        return nArray[0];
    }

    public int getHeight() {
        int[] nArray = new int[1];
        if (!EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray, 0)) {
            throw new GLException("Error querying surface height");
        }
        return nArray[0];
    }

    public DynamicLookupHelper getDynamicLookupHelper() {
        return EGLDynamicLookupHelper.getDynamicLookupHelper(this.getGLProfile());
    }

    public String toString() {
        return "EGLDrawable[ realized " + this.getRealized() + ", window " + this.getNativeWindow() + ", egl surface " + this.eglSurface + ", " + this.eglConfig + ", factory " + this.getFactory() + "]";
    }
}

