/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformRandomAccess<T>
extends AbstractLocalizable
implements RandomAccess<T> {
    private final RandomAccess<T> source;
    private final Transform transformToSource;
    private final long[] tmp;

    TransformRandomAccess(RandomAccess<T> source, Transform transformToSource) {
        super(transformToSource.numSourceDimensions());
        this.source = source;
        this.transformToSource = transformToSource;
        this.tmp = new long[transformToSource.numTargetDimensions()];
    }

    protected TransformRandomAccess(TransformRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.source = randomAccess.source.copyRandomAccess();
        this.transformToSource = randomAccess.transformToSource;
        this.tmp = new long[randomAccess.tmp.length];
    }

    @Override
    public void fwd(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + 1L;
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void bck(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] - 1L;
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void move(int distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void move(long distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + distance;
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void move(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getLongPosition(d);
        }
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void move(int[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
        }
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void move(long[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() == this.n);
        localizable.localize(this.position);
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int[] pos) {
        assert (pos.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(long[] pos) {
        assert (pos.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int pos, int d) {
        assert (d < this.n);
        this.position[d] = pos;
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public void setPosition(long pos, int d) {
        assert (d < this.n);
        this.position[d] = pos;
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
    }

    @Override
    public T get() {
        return this.source.get();
    }

    @Override
    public TransformRandomAccess<T> copy() {
        return new TransformRandomAccess<T>(this);
    }

    @Override
    public TransformRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

