/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.Iterator;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.view.RandomAccessibleIntervalCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableRandomAccessibleInterval<T>
extends AbstractWrappedInterval<RandomAccessibleInterval<T>>
implements IterableInterval<T>,
RandomAccessibleInterval<T> {
    final long size;

    public static <T> IterableRandomAccessibleInterval<T> create(RandomAccessibleInterval<T> interval) {
        return new IterableRandomAccessibleInterval<T>(interval);
    }

    public IterableRandomAccessibleInterval(RandomAccessibleInterval<T> interval) {
        super(interval);
        int n = this.numDimensions();
        long s = interval.dimension(0);
        for (int d = 1; d < n; ++d) {
            s *= interval.dimension(d);
        }
        this.size = s;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public T firstElement() {
        return (T)this.cursor().next();
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder((Interval)this.sourceInterval);
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public Cursor<T> cursor() {
        return new RandomAccessibleIntervalCursor((RandomAccessible)((Object)this.sourceInterval));
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.cursor();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return ((RandomAccessibleInterval)this.sourceInterval).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval i) {
        return ((RandomAccessibleInterval)this.sourceInterval).randomAccess(i);
    }
}

