/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealPositionable;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.ImgPlus;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.TransformBuilder;
import net.imglib2.view.Views;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperSliceImgPlus<T>
extends ImgPlus<T> {
    protected final int nDimensions;
    protected final ImgPlus<T> source;
    protected final IterableInterval<T> fullViewIterable;
    protected RandomAccessible<T> fullViewRandomAccessible;
    protected final MixedTransformView<T> mtv;
    protected final int targetDimension;
    protected final long dimensionPosition;

    public HyperSliceImgPlus(ImgPlus<T> source, int d, long pos) {
        super(source);
        int m = source.numDimensions();
        this.nDimensions = m - 1;
        this.targetDimension = d;
        this.dimensionPosition = pos;
        long[] min = new long[this.nDimensions];
        long[] max = new long[this.nDimensions];
        MixedTransform t = new MixedTransform(this.nDimensions, m);
        long[] translation = new long[m];
        translation[d] = pos;
        boolean[] zero = new boolean[m];
        int[] component = new int[m];
        for (int e = 0; e < m; ++e) {
            if (e < d) {
                zero[e] = false;
                component[e] = e;
                min[e] = source.min(e);
                max[e] = source.max(e);
                this.setCalibration(source.calibration(e), e);
                this.setAxis(source.axis(e), e);
                continue;
            }
            if (e > d) {
                zero[e] = false;
                component[e] = e - 1;
                min[e - 1] = source.min(e);
                max[e - 1] = source.max(e);
                this.setCalibration(source.calibration(e), e - 1);
                this.setAxis(source.axis(e), e - 1);
                continue;
            }
            zero[e] = true;
            component[e] = 0;
        }
        this.setName("Hypserslice of " + source.getName() + " at dim " + d + "=" + pos);
        t.setTranslation(translation);
        t.setComponentZero(zero);
        t.setComponentMapping(component);
        this.mtv = new MixedTransformView<T>(source, t);
        int index = 0;
        for (int i = 0; i < m; ++i) {
            if (i == d) continue;
            this.setCalibration(source.calibration(i), index);
            this.setAxis(source.axis(i), index);
            ++index;
        }
        this.source = source;
        this.fullViewRandomAccessible = TransformBuilder.getEfficientRandomAccessible(null, this.mtv);
        this.fullViewIterable = Views.iterable(Views.interval(this.fullViewRandomAccessible, min, max));
    }

    @Override
    public Img<T> getImg() {
        return super.getImg();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return TransformBuilder.getEfficientRandomAccessible(interval, this.mtv).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return this.fullViewRandomAccessible.randomAccess();
    }

    @Override
    public int numDimensions() {
        return this.nDimensions;
    }

    @Override
    public long min(int d) {
        if (d < this.targetDimension) {
            return this.source.min(d);
        }
        return this.source.min(d + 1);
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.nDimensions; ++d) {
            min[d] = d < this.targetDimension ? this.source.min(d) : this.source.min(d + 1);
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.nDimensions; ++d) {
            if (d < this.targetDimension) {
                min.setPosition(this.source.min(d), d);
                continue;
            }
            min.setPosition(this.source.min(d + 1), d);
        }
    }

    @Override
    public long max(int d) {
        if (d < this.targetDimension) {
            return this.source.max(d);
        }
        return this.source.max(d + 1);
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.nDimensions; ++d) {
            max[d] = d < this.targetDimension ? this.source.max(d) : this.source.max(d + 1);
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.nDimensions; ++d) {
            if (d < this.targetDimension) {
                max.setPosition(this.source.max(d), d);
                continue;
            }
            max.setPosition(this.source.max(d + 1), d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.nDimensions; ++d) {
            dimensions[d] = d < this.targetDimension ? this.source.dimension(d) : this.source.dimension(d + 1);
        }
    }

    @Override
    public long dimension(int d) {
        if (d < this.targetDimension) {
            return this.source.dimension(d);
        }
        return this.source.dimension(d + 1);
    }

    @Override
    public double realMin(int d) {
        if (d < this.targetDimension) {
            return this.source.realMin(d);
        }
        return this.source.realMin(d + 1);
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.nDimensions; ++d) {
            min[d] = d < this.targetDimension ? this.source.realMin(d) : this.source.realMin(d + 1);
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.nDimensions; ++d) {
            if (d < this.targetDimension) {
                min.setPosition(this.source.realMin(d), d);
                continue;
            }
            min.setPosition(this.source.realMin(d + 1), d);
        }
    }

    @Override
    public double realMax(int d) {
        if (d < this.targetDimension) {
            return this.source.realMax(d);
        }
        return this.source.realMax(d + 1);
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.nDimensions; ++d) {
            max[d] = d < this.targetDimension ? this.source.realMax(d) : this.source.realMax(d + 1);
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.nDimensions; ++d) {
            if (d < this.targetDimension) {
                max.setPosition(this.source.realMax(d), d);
                continue;
            }
            max.setPosition(this.source.realMax(d + 1), d);
        }
    }

    @Override
    public Cursor<T> cursor() {
        return this.fullViewIterable.cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.fullViewIterable.localizingCursor();
    }

    @Override
    public long size() {
        long size = 1L;
        for (int d = 0; d < this.nDimensions; ++d) {
            size *= this.dimension(d);
        }
        return size;
    }

    @Override
    public T firstElement() {
        return this.source.firstElement();
    }

    @Override
    public Object iterationOrder() {
        return this.fullViewIterable;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public Iterator<T> iterator() {
        return this.fullViewIterable.iterator();
    }

    @Override
    public ImgFactory<T> factory() {
        return this.source.factory();
    }

    @Override
    public HyperSliceImgPlus<T> copy() {
        return new HyperSliceImgPlus<T>(this.source, this.targetDimension, this.dimensionPosition);
    }

    public static final <T> ImgPlus<T> fixAxis(ImgPlus<T> source, AxisType axis, long pos) {
        int targetDim = -1;
        for (int d = 0; d < source.numDimensions(); ++d) {
            if (!source.axis(d).equals(axis)) continue;
            targetDim = d;
            break;
        }
        if (targetDim < 0) {
            return source;
        }
        return new HyperSliceImgPlus<T>(source, targetDim, pos);
    }

    public static final <T> ImgPlus<T> fixTimeAxis(ImgPlus<T> source, long pos) {
        return HyperSliceImgPlus.fixAxis(source, Axes.TIME, pos);
    }

    public static final <T> ImgPlus<T> fixZAxis(ImgPlus<T> source, long pos) {
        return HyperSliceImgPlus.fixAxis(source, Axes.Z, pos);
    }

    public static final <T> ImgPlus<T> fixChannelAxis(ImgPlus<T> source, long pos) {
        return HyperSliceImgPlus.fixAxis(source, Axes.CHANNEL, pos);
    }
}

