/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

public class IntervalIndexer {
    public static final int positionToIndex(int[] position, int[] dimensions) {
        int maxDim = dimensions.length - 1;
        int i = position[maxDim];
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * dimensions[d] + position[d];
        }
        return i;
    }

    public static final int positionToIndex(long[] position, int[] dimensions) {
        int maxDim = dimensions.length - 1;
        int i = (int)position[maxDim];
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * dimensions[d] + (int)position[d];
        }
        return i;
    }

    public static final long positionToIndex(long[] position, long[] dimensions) {
        int maxDim = dimensions.length - 1;
        long i = position[maxDim];
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * dimensions[d] + position[d];
        }
        return i;
    }

    public static final long positionWithOffsetToIndex(long[] position, long[] dimensions, long[] offsets) {
        int maxDim = dimensions.length - 1;
        long i = position[maxDim] - offsets[maxDim];
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * dimensions[d] + position[d] - offsets[d];
        }
        return i;
    }

    public static final int positionWithOffsetToIndex(int[] position, int[] dimensions, int[] offsets) {
        int maxDim = dimensions.length - 1;
        int i = position[maxDim] - offsets[maxDim];
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * dimensions[d] + position[d] - offsets[d];
        }
        return i;
    }

    public static final void indexToPosition(int index, int[] dimensions, int[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            int j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPosition(long index, long[] dimensions, int[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = (int)(index - j * dimensions[d]);
            index = j;
        }
        position[maxDim] = (int)index;
    }

    public static final void indexToPosition(int index, int[] dimensions, long[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            int j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPosition(long index, long[] dimensions, long[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPosition(int index, int[] dimensions, float[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            int j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPosition(long index, long[] dimensions, float[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPosition(int index, int[] dimensions, double[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            int j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPosition(long index, long[] dimensions, double[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = index - j * dimensions[d];
            index = j;
        }
        position[maxDim] = index;
    }

    public static final void indexToPositionWithOffset(int index, int[] dimensions, int[] offsets, int[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            int j = index / dimensions[d];
            position[d] = index - j * dimensions[d] + offsets[d];
            index = j;
        }
        position[maxDim] = index + offsets[maxDim];
    }

    public static final void indexToPositionWithOffset(long index, long[] dimensions, long[] offsets, long[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = index - j * dimensions[d] + offsets[d];
            index = j;
        }
        position[maxDim] = index + offsets[maxDim];
    }

    public static final void indexToPositionWithOffset(long index, long[] dimensions, long[] offsets, int[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = (int)(index - j * dimensions[d] + offsets[d]);
            index = j;
        }
        position[maxDim] = (int)(index + offsets[maxDim]);
    }

    public static final void indexToPositionWithOffset(long index, long[] dimensions, long[] offsets, float[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = index - j * dimensions[d] + offsets[d];
            index = j;
        }
        position[maxDim] = index + offsets[maxDim];
    }

    public static final void indexToPositionWithOffset(long index, long[] dimensions, long[] offsets, double[] position) {
        int maxDim = dimensions.length - 1;
        for (int d = 0; d < maxDim; ++d) {
            long j = index / dimensions[d];
            position[d] = index - j * dimensions[d] + offsets[d];
            index = j;
        }
        position[maxDim] = index + offsets[maxDim];
    }

    public static final int indexToPosition(int index, int[] dimensions, int dimension) {
        int step = 1;
        for (int d = 0; d < dimension; ++d) {
            step *= dimensions[d];
        }
        return index / step % dimensions[dimension];
    }

    public static final long indexToPosition(long index, long[] dimensions, int dimension) {
        int step = 1;
        for (int d = 0; d < dimension; ++d) {
            step = (int)((long)step * dimensions[d]);
        }
        return index / (long)step % dimensions[dimension];
    }

    public static final int indexToPositionWithOffset(int index, int[] dimensions, int[] offsets, int dimension) {
        return IntervalIndexer.indexToPosition(index, dimensions, dimension) + offsets[dimension];
    }

    public static final int indexToPosition(int index, int[] dimensions, int[] steps, int dimension) {
        return index / steps[dimension] % dimensions[dimension];
    }

    public static final long indexToPosition(long index, long[] dimensions, long[] steps, int dimension) {
        return index / steps[dimension] % dimensions[dimension];
    }

    public static final int indexToPositionWithOffset(int index, int[] dimensions, int[] steps, int[] offset, int dimension) {
        return IntervalIndexer.indexToPosition(index, dimensions, steps, dimension) + offset[dimension];
    }

    public static final long indexToPositionWithOffset(long index, long[] dimensions, long[] steps, long[] offsets, int dimension) {
        return IntervalIndexer.indexToPosition(index, dimensions, steps, dimension) + offsets[dimension];
    }

    public static void createAllocationSteps(long[] dimensions, long[] steps) {
        steps[0] = 1L;
        for (int d = 1; d < dimensions.length; ++d) {
            steps[d] = steps[d - 1] * dimensions[d - 1];
        }
    }

    public static void createAllocationSteps(int[] dimensions, int[] steps) {
        steps[0] = 1;
        for (int d = 1; d < dimensions.length; ++d) {
            steps[d] = steps[d - 1] * dimensions[d - 1];
        }
    }
}

