/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkHelper {
    public static Long median(ArrayList<Long> values) {
        Collections.sort(values);
        if (values.size() % 2 == 1) {
            return values.get((values.size() + 1) / 2 - 1);
        }
        long lower = values.get(values.size() / 2 - 1);
        long upper = values.get(values.size() / 2);
        return (lower + upper) / 2L;
    }

    public static ArrayList<Long> benchmark(int numRuns, Runnable benchmark) {
        ArrayList<Long> times = new ArrayList<Long>(numRuns);
        for (int i = 0; i < numRuns; ++i) {
            long startTime = System.currentTimeMillis();
            benchmark.run();
            long endTime = System.currentTimeMillis();
            times.add(endTime - startTime);
        }
        return times;
    }

    public static void benchmarkAndPrint(int numRuns, boolean printIndividualTimes, Runnable b) {
        int i;
        ArrayList<Long> times = new ArrayList<Long>(100);
        for (i = 0; i < numRuns; ++i) {
            long startTime = System.currentTimeMillis();
            b.run();
            long endTime = System.currentTimeMillis();
            times.add(endTime - startTime);
        }
        if (printIndividualTimes) {
            for (i = 0; i < numRuns; ++i) {
                System.out.println("run " + i + ": " + times.get(i) + " ms");
            }
            System.out.println();
        }
        System.out.println("median: " + BenchmarkHelper.median(times) + " ms");
        System.out.println();
    }
}

