/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.real;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.AbstractRealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatType
extends AbstractRealType<FloatType>
implements NativeType<FloatType> {
    private int i = 0;
    protected final NativeImg<FloatType, ? extends FloatAccess> img;
    protected FloatAccess dataAccess;

    public FloatType(NativeImg<FloatType, ? extends FloatAccess> floatStorage) {
        this.img = floatStorage;
    }

    public FloatType(float value) {
        this.img = null;
        this.dataAccess = new FloatArray(1);
        this.set(value);
    }

    public FloatType(FloatAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public FloatType() {
        this(0.0f);
    }

    @Override
    public NativeImg<FloatType, ? extends FloatAccess> createSuitableNativeImg(NativeImgFactory<FloatType> storageFactory, long[] dim) {
        NativeImg<FloatType, FloatAccess> container = storageFactory.createFloatInstance(dim, 1);
        FloatType linkedType = new FloatType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public FloatType duplicateTypeOnSameNativeImg() {
        return new FloatType(this.img);
    }

    public float get() {
        return this.dataAccess.getValue(this.i);
    }

    @Override
    public void set(float f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public float getRealFloat() {
        return this.get();
    }

    @Override
    public double getRealDouble() {
        return this.get();
    }

    @Override
    public void setReal(float real) {
        this.set(real);
    }

    @Override
    public void setReal(double real) {
        this.set((float)real);
    }

    @Override
    public double getMaxValue() {
        return 3.4028234663852886E38;
    }

    @Override
    public double getMinValue() {
        return -3.4028234663852886E38;
    }

    @Override
    public double getMinIncrement() {
        return 1.4E-45f;
    }

    @Override
    public void mul(float c) {
        this.set(this.get() * c);
    }

    @Override
    public void mul(double c) {
        this.set((float)((double)this.get() * c));
    }

    @Override
    public void add(FloatType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(FloatType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(FloatType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(FloatType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public int compareTo(FloatType c) {
        float b;
        float a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(FloatType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(1.0f);
    }

    @Override
    public void setZero() {
        this.set(0.0f);
    }

    @Override
    public void inc() {
        float a = this.get();
        this.set(a += 1.0f);
    }

    @Override
    public void dec() {
        float a = this.get();
        this.set(a -= 1.0f);
    }

    @Override
    public FloatType createVariable() {
        return new FloatType(0.0f);
    }

    @Override
    public FloatType copy() {
        return new FloatType(this.get());
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 32;
    }
}

