/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedByteType
extends GenericByteType<UnsignedByteType> {
    public UnsignedByteType(NativeImg<UnsignedByteType, ? extends ByteAccess> img) {
        super(img);
    }

    public UnsignedByteType(int value) {
        super(UnsignedByteType.getCodedSignedByteChecked(value));
    }

    public UnsignedByteType(ByteAccess access) {
        super(access);
    }

    public UnsignedByteType() {
        this(0);
    }

    public static byte getCodedSignedByteChecked(int unsignedByte) {
        if (unsignedByte < 0) {
            unsignedByte = 0;
        } else if (unsignedByte > 255) {
            unsignedByte = 255;
        }
        return UnsignedByteType.getCodedSignedByte(unsignedByte);
    }

    public static byte getCodedSignedByte(int unsignedByte) {
        return (byte)(unsignedByte & 0xFF);
    }

    public static int getUnsignedByte(byte signedByte) {
        return signedByte & 0xFF;
    }

    @Override
    public NativeImg<UnsignedByteType, ? extends ByteAccess> createSuitableNativeImg(NativeImgFactory<UnsignedByteType> storageFactory, long[] dim) {
        NativeImg<UnsignedByteType, ByteAccess> container = storageFactory.createByteInstance(dim, 1);
        UnsignedByteType linkedType = new UnsignedByteType((NativeImg<UnsignedByteType, ? extends ByteAccess>)container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedByteType duplicateTypeOnSameNativeImg() {
        return new UnsignedByteType(this.img);
    }

    @Override
    public void mul(float c) {
        int a = UnsignedByteType.getUnsignedByte(this.getValue());
        this.setValue(UnsignedByteType.getCodedSignedByte(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        int a = UnsignedByteType.getUnsignedByte(this.getValue());
        this.setValue(UnsignedByteType.getCodedSignedByte((int)Util.round((double)a * c)));
    }

    @Override
    public void add(UnsignedByteType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedByteType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(UnsignedByteType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedByteType c) {
        this.set(this.get() - c.get());
    }

    public int get() {
        return UnsignedByteType.getUnsignedByte(this.getValue());
    }

    @Override
    public void set(int f) {
        this.setValue(UnsignedByteType.getCodedSignedByte(f));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set((int)f);
    }

    @Override
    public double getMaxValue() {
        return 255.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int compareTo(UnsignedByteType c) {
        int b;
        int a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public UnsignedByteType createVariable() {
        return new UnsignedByteType(0);
    }

    @Override
    public UnsignedByteType copy() {
        return new UnsignedByteType(this.get());
    }

    @Override
    public String toString() {
        return "" + this.get();
    }
}

