/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongType
extends AbstractIntegerType<LongType>
implements NativeType<LongType> {
    private int i = 0;
    protected final NativeImg<LongType, ? extends LongAccess> img;
    protected LongAccess dataAccess;

    public LongType(NativeImg<LongType, ? extends LongAccess> longStorage) {
        this.img = longStorage;
    }

    public LongType(LongAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public LongType(long value) {
        this.img = null;
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public LongType() {
        this(0L);
    }

    @Override
    public NativeImg<LongType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<LongType> storageFactory, long[] dim) {
        NativeImg<LongType, LongAccess> container = storageFactory.createLongInstance(dim, 1);
        LongType linkedType = new LongType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public LongType duplicateTypeOnSameNativeImg() {
        return new LongType(this.img);
    }

    public long get() {
        return this.dataAccess.getValue(this.i);
    }

    @Override
    public void set(long f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public double getMaxValue() {
        return 9.223372036854776E18;
    }

    @Override
    public double getMinValue() {
        return -9.223372036854776E18;
    }

    @Override
    public void mul(float c) {
        this.set(Util.round((float)this.get() * c));
    }

    @Override
    public void mul(double c) {
        this.set(Util.round((double)this.get() * c));
    }

    @Override
    public void add(LongType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(LongType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(LongType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(LongType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public int compareTo(LongType c) {
        long b;
        long a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(LongType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        long a = this.get();
        this.set(++a);
    }

    @Override
    public void dec() {
        long a = this.get();
        this.set(--a);
    }

    @Override
    public LongType createVariable() {
        return new LongType(0L);
    }

    @Override
    public LongType copy() {
        return new LongType(this.get());
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 64;
    }
}

