/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericShortType<T extends GenericShortType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    int i = 0;
    protected final NativeImg<T, ? extends ShortAccess> img;
    protected ShortAccess dataAccess;

    public GenericShortType(NativeImg<T, ? extends ShortAccess> shortStorage) {
        this.img = shortStorage;
    }

    public GenericShortType(short value) {
        this.img = null;
        this.dataAccess = new ShortArray(1);
        this.setValue(value);
    }

    protected GenericShortType(ShortAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericShortType() {
        this(0);
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    protected short getValue() {
        return this.dataAccess.getValue(this.i);
    }

    protected void setValue(short f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        short a = this.getValue();
        this.setValue((short)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        short a = this.getValue();
        this.setValue((short)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        short a = this.getValue();
        this.setValue((short)(a + ((GenericShortType)c).getValue()));
    }

    @Override
    public void div(T c) {
        short a = this.getValue();
        this.setValue((short)(a / ((GenericShortType)c).getValue()));
    }

    @Override
    public void mul(T c) {
        short a = this.getValue();
        this.setValue((short)(a * ((GenericShortType)c).getValue()));
    }

    @Override
    public void sub(T c) {
        short a = this.getValue();
        this.setValue((byte)(a - ((GenericShortType)c).getValue()));
    }

    @Override
    public int compareTo(T c) {
        short b;
        short a = this.getValue();
        if (a > (b = ((GenericShortType)c).getValue())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setValue(((GenericShortType)c).getValue());
    }

    @Override
    public void setOne() {
        this.setValue((short)1);
    }

    @Override
    public void setZero() {
        this.setValue((short)0);
    }

    @Override
    public void inc() {
        short a = this.getValue();
        a = (short)(a + 1);
        this.setValue(a);
    }

    @Override
    public void dec() {
        short a = this.getValue();
        a = (short)(a - 1);
        this.setValue(a);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 16;
    }
}

