/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericIntType<T extends GenericIntType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    int i = 0;
    protected final NativeImg<T, ? extends IntAccess> img;
    protected IntAccess dataAccess;

    public GenericIntType(NativeImg<T, ? extends IntAccess> intStorage) {
        this.img = intStorage;
    }

    public GenericIntType(int value) {
        this.img = null;
        this.dataAccess = new IntArray(1);
        this.setValue(value);
    }

    protected GenericIntType(IntAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericIntType() {
        this(0);
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    protected int getValue() {
        return this.dataAccess.getValue(this.i);
    }

    protected void setValue(int f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        int a = this.getValue();
        this.setValue(Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        int a = this.getValue();
        this.setValue((int)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        int a = this.getValue();
        this.setValue(a + ((GenericIntType)c).getValue());
    }

    @Override
    public void div(T c) {
        int a = this.getValue();
        this.setValue(a / ((GenericIntType)c).getValue());
    }

    @Override
    public void mul(T c) {
        int a = this.getValue();
        this.setValue(a * ((GenericIntType)c).getValue());
    }

    @Override
    public void sub(T c) {
        int a = this.getValue();
        this.setValue(a - ((GenericIntType)c).getValue());
    }

    @Override
    public int compareTo(T c) {
        int b;
        int a = this.getValue();
        if (a > (b = ((GenericIntType)c).getValue())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setValue(((GenericIntType)c).getValue());
    }

    @Override
    public void setOne() {
        this.setValue(1);
    }

    @Override
    public void setZero() {
        this.setValue(0);
    }

    @Override
    public void inc() {
        int a = this.getValue();
        this.setValue(++a);
    }

    @Override
    public void dec() {
        int a = this.getValue();
        this.setValue(--a);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 32;
    }
}

