/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericByteType<T extends GenericByteType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    int i = 0;
    protected final NativeImg<T, ? extends ByteAccess> img;
    protected ByteAccess dataAccess;

    public GenericByteType(NativeImg<T, ? extends ByteAccess> byteStorage) {
        this.img = byteStorage;
    }

    protected GenericByteType(byte value) {
        this.img = null;
        this.dataAccess = new ByteArray(1);
        this.setValue(value);
    }

    protected GenericByteType(ByteAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    protected GenericByteType() {
        this(0);
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    protected byte getValue() {
        return this.dataAccess.getValue(this.i);
    }

    protected void setValue(byte f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        byte a = this.getValue();
        this.setValue((byte)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        byte a = this.getValue();
        this.setValue((byte)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a + ((GenericByteType)c).getValue()));
    }

    @Override
    public void div(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a / ((GenericByteType)c).getValue()));
    }

    @Override
    public void mul(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a * ((GenericByteType)c).getValue()));
    }

    @Override
    public void sub(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a - ((GenericByteType)c).getValue()));
    }

    @Override
    public int compareTo(T c) {
        byte b;
        byte a = this.getValue();
        if (a > (b = ((GenericByteType)c).getValue())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setValue(((GenericByteType)c).getValue());
    }

    @Override
    public void setOne() {
        this.setValue((byte)1);
    }

    @Override
    public void setZero() {
        this.setValue((byte)0);
    }

    @Override
    public void inc() {
        byte a = this.getValue();
        a = (byte)(a + 1);
        this.setValue(a);
    }

    @Override
    public void dec() {
        byte a = this.getValue();
        a = (byte)(a - 1);
        this.setValue(a);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 8;
    }
}

