/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.complex;

import net.imglib2.type.numeric.ComplexType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComplexType<T extends AbstractComplexType<T>>
implements ComplexType<T> {
    @Override
    public void set(T c) {
        this.setReal(c.getRealDouble());
        this.setImaginary(c.getImaginaryDouble());
    }

    @Override
    public void mul(float c) {
        this.setReal(this.getRealFloat() * c);
        this.setImaginary(this.getImaginaryFloat() * c);
    }

    @Override
    public void mul(double c) {
        this.setReal(this.getRealDouble() * c);
        this.setImaginary(this.getImaginaryDouble() * c);
    }

    @Override
    public void add(T c) {
        this.setReal(this.getRealDouble() + c.getRealDouble());
        this.setImaginary(this.getImaginaryDouble() + c.getImaginaryDouble());
    }

    @Override
    public void div(T c) {
        double a1 = this.getRealDouble();
        double b1 = this.getImaginaryDouble();
        double c1 = c.getRealDouble();
        double d1 = c.getImaginaryDouble();
        this.setReal((a1 * c1 + b1 * d1) / (c1 * c1 + d1 * d1));
        this.setImaginary((b1 * c1 - a1 * d1) / (c1 * c1 + d1 * d1));
    }

    @Override
    public void mul(T t) {
        double a = this.getRealDouble();
        double b = this.getImaginaryDouble();
        double c = t.getRealDouble();
        double d = t.getImaginaryDouble();
        this.setReal(a * c - b * d);
        this.setImaginary(a * d + b * c);
    }

    @Override
    public void sub(T c) {
        this.setReal(this.getRealDouble() - c.getRealDouble());
        this.setImaginary(this.getImaginaryDouble() - c.getImaginaryDouble());
    }

    @Override
    public void complexConjugate() {
        this.setImaginary(-this.getImaginaryDouble());
    }

    @Override
    public float getPowerFloat() {
        double real = this.getRealDouble();
        double imaginary = this.getImaginaryDouble();
        return (float)Math.sqrt(real * real + imaginary * imaginary);
    }

    @Override
    public double getPowerDouble() {
        double real = this.getRealDouble();
        double imaginary = this.getImaginaryDouble();
        return Math.sqrt(real * real + imaginary * imaginary);
    }

    @Override
    public float getPhaseFloat() {
        return (float)Math.atan2(this.getImaginaryDouble(), this.getRealDouble());
    }

    @Override
    public double getPhaseDouble() {
        return Math.atan2(this.getImaginaryDouble(), this.getRealDouble());
    }

    @Override
    public void setOne() {
        this.setReal(1.0f);
        this.setImaginary(0.0f);
    }

    @Override
    public void setZero() {
        this.setReal(0.0f);
        this.setImaginary(0.0f);
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.setReal(r);
        this.setImaginary(i);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.setReal(r);
        this.setImaginary(i);
    }

    public String toString() {
        return "(" + this.getRealDouble() + ") + (" + this.getImaginaryDouble() + ")i";
    }
}

