/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.logic;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.BitAccess;
import net.imglib2.img.basictypeaccess.array.BitArray;
import net.imglib2.type.BooleanType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitType
extends AbstractIntegerType<BitType>
implements BooleanType<BitType>,
NativeType<BitType> {
    private int i = 0;
    protected final NativeImg<BitType, ? extends BitAccess> img;
    protected BitAccess dataAccess;

    public BitType(NativeImg<BitType, ? extends BitAccess> bitStorage) {
        this.img = bitStorage;
    }

    public BitType(boolean value) {
        this.img = null;
        this.dataAccess = new BitArray(1);
        this.dataAccess.setValue(this.i, value);
    }

    public BitType(BitAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public BitType() {
        this(false);
    }

    @Override
    public NativeImg<BitType, ? extends BitAccess> createSuitableNativeImg(NativeImgFactory<BitType> storageFactory, long[] dim) {
        NativeImg<BitType, BitAccess> container = storageFactory.createBitInstance(dim, 1);
        BitType linkedType = new BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public BitType duplicateTypeOnSameNativeImg() {
        return new BitType(this.img);
    }

    @Override
    public boolean get() {
        return this.dataAccess.getValue(this.i);
    }

    @Override
    public void set(boolean value) {
        this.dataAccess.setValue(this.i, value);
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public void setInteger(int f) {
        if (f >= 1) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setInteger(long f) {
        if (f >= 1L) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void set(BitType c) {
        this.dataAccess.setValue(this.i, c.get());
    }

    @Override
    public void and(BitType c) {
        this.dataAccess.setValue(this.i, this.dataAccess.getValue(this.i) && c.get());
    }

    @Override
    public void or(BitType c) {
        this.dataAccess.setValue(this.i, this.dataAccess.getValue(this.i) || c.get());
    }

    @Override
    public void xor(BitType c) {
        this.dataAccess.setValue(this.i, this.dataAccess.getValue(this.i) ^ c.get());
    }

    @Override
    public void not() {
        this.dataAccess.setValue(this.i, !this.dataAccess.getValue(this.i));
    }

    @Override
    public void add(BitType c) {
        this.xor(c);
    }

    @Override
    public void div(BitType c) {
        this.and(c);
    }

    @Override
    public void mul(BitType c) {
        this.and(c);
    }

    @Override
    public void sub(BitType c) {
        this.xor(c);
    }

    @Override
    public void mul(float c) {
        if (c >= 0.5f) {
            this.dataAccess.setValue(this.i, this.dataAccess.getValue(this.i));
        } else {
            if (this.dataAccess.getValue(this.i)) {
                // empty if block
            }
            this.dataAccess.setValue(this.i, false);
        }
    }

    @Override
    public void mul(double c) {
        if (c >= 0.5) {
            this.dataAccess.setValue(this.i, this.dataAccess.getValue(this.i));
        } else {
            if (this.dataAccess.getValue(this.i)) {
                // empty if block
            }
            this.dataAccess.setValue(this.i, false);
        }
    }

    @Override
    public void setOne() {
        this.dataAccess.setValue(this.i, true);
    }

    @Override
    public void setZero() {
        this.dataAccess.setValue(this.i, false);
    }

    @Override
    public void inc() {
        this.dataAccess.setValue(this.i, !this.dataAccess.getValue(this.i));
    }

    @Override
    public void dec() {
        this.inc();
    }

    @Override
    public int compareTo(BitType c) {
        boolean b1 = this.dataAccess.getValue(this.i);
        boolean b2 = c.get();
        if (b1 && !b2) {
            return 1;
        }
        if (!b1 && b2) {
            return -1;
        }
        return 0;
    }

    @Override
    public BitType createVariable() {
        return new BitType();
    }

    @Override
    public BitType copy() {
        return new BitType(this.dataAccess.getValue(this.i));
    }

    @Override
    public String toString() {
        boolean value = this.dataAccess.getValue(this.i);
        return value ? "1" : "0";
    }

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 1;
    }
}

