/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.CharAccess;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.type.AbstractNativeType;
import net.imglib2.type.BasePairType;
import net.imglib2.type.label.BasePairBitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePairCharType
extends AbstractNativeType<BasePairCharType>
implements BasePairType<BasePairCharType> {
    protected final NativeImg<BasePairCharType, ? extends CharAccess> img;
    protected CharAccess dataAccess;

    @Override
    public int getEntitiesPerPixel() {
        return 1;
    }

    public BasePairCharType(NativeImg<BasePairCharType, ? extends CharAccess> charStorage) {
        this.img = charStorage;
    }

    public BasePairCharType(BasePairBitType.Base value) {
        this.img = null;
        this.dataAccess = new CharArray(1);
        this.set(value);
    }

    public BasePairCharType(char value) {
        this.img = null;
        this.dataAccess = new CharArray(1);
        this.setChar(value);
    }

    public BasePairCharType() {
        this(BasePairBitType.Base.N);
    }

    @Override
    public NativeImg<BasePairCharType, ? extends CharAccess> createSuitableNativeImg(NativeImgFactory<BasePairCharType> storageFactory, long[] dim) {
        NativeImg<BasePairCharType, CharAccess> container = storageFactory.createCharInstance(dim, 1);
        BasePairCharType linkedType = new BasePairCharType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public BasePairCharType duplicateTypeOnSameNativeImg() {
        return new BasePairCharType(this.img);
    }

    public char getChar() {
        return this.dataAccess.getValue(this.i);
    }

    public void setChar(char f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void set(BasePairBitType.Base base) {
        switch (base) {
            case A: {
                this.setChar('A');
                return;
            }
            case T: {
                this.setChar('T');
                return;
            }
            case G: {
                this.setChar('G');
                return;
            }
            case C: {
                this.setChar('C');
                return;
            }
            case gap: {
                this.setChar(' ');
                return;
            }
        }
        this.setChar('N');
    }

    @Override
    public BasePairBitType.Base get() {
        char value = this.getChar();
        switch (value) {
            case 'A': {
                return BasePairBitType.Base.A;
            }
            case 'T': {
                return BasePairBitType.Base.T;
            }
            case 'G': {
                return BasePairBitType.Base.G;
            }
            case 'C': {
                return BasePairBitType.Base.C;
            }
            case ' ': {
                return BasePairBitType.Base.gap;
            }
        }
        return BasePairBitType.Base.N;
    }

    @Override
    public void set(BasePairCharType c) {
        this.dataAccess.setValue(this.i, c.getChar());
    }

    @Override
    public int compareTo(BasePairCharType c) {
        char compare;
        char input = this.getChar();
        if (input == (compare = c.getChar())) {
            return 0;
        }
        switch (input) {
            case ' ': {
                return -1;
            }
            case 'N': {
                return compare == ' ' ? 1 : -1;
            }
            case 'A': {
                return compare == ' ' || compare == 'N' ? 1 : -1;
            }
            case 'T': {
                return compare == 'G' || compare == 'C' ? -1 : 1;
            }
            case 'G': {
                return compare == 'C' ? -1 : 1;
            }
        }
        return 1;
    }

    @Override
    public void complement() {
        char base = this.getChar();
        switch (base) {
            case 'A': {
                this.setChar('T');
                break;
            }
            case 'T': {
                this.setChar('A');
                break;
            }
            case 'G': {
                this.setChar('C');
                break;
            }
            case 'C': {
                this.setChar('G');
            }
        }
    }

    @Override
    public byte baseToValue() {
        char base = this.getChar();
        switch (base) {
            case 'N': {
                return 1;
            }
            case 'A': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'G': {
                return 4;
            }
            case 'C': {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public BasePairCharType createVariable() {
        return new BasePairCharType(BasePairBitType.Base.N);
    }

    @Override
    public BasePairCharType copy() {
        return new BasePairCharType(this.get());
    }

    @Override
    public String toString() {
        return "" + (Object)((Object)this.get());
    }
}

