/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.transform.integer.AbstractMixedTransform;
import net.imglib2.transform.integer.Translation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationTransform
extends AbstractMixedTransform
implements Translation,
Concatenable<Translation>,
PreConcatenable<Translation> {
    protected final long[] translation;
    protected final InverseTranslationTransform inverse;

    public TranslationTransform(int targetDim) {
        super(targetDim);
        this.translation = new long[targetDim];
        this.inverse = new InverseTranslationTransform(targetDim);
    }

    public TranslationTransform(long[] translation) {
        super(translation.length);
        this.translation = (long[])translation.clone();
        this.inverse = new InverseTranslationTransform(this.numTargetDimensions);
    }

    @Override
    public void getTranslation(long[] t) {
        assert (t.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            t[d] = this.translation[d];
        }
    }

    @Override
    public long getTranslation(int d) {
        assert (d <= this.numTargetDimensions);
        return this.translation[d];
    }

    public void setTranslation(long[] t) {
        assert (t.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.translation[d] = t[d];
        }
    }

    @Override
    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = source[d] + this.translation[d];
        }
    }

    @Override
    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = source[d] + (int)this.translation[d];
        }
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numTargetDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target.setPosition(source.getLongPosition(d) + this.translation[d], d);
        }
    }

    public TranslationTransform concatenate(Translation t) {
        assert (this.numTargetDimensions == t.numTargetDimensions());
        TranslationTransform result = new TranslationTransform(this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            result.translation[d] = this.translation[d] + t.getTranslation(d);
        }
        return result;
    }

    @Override
    public Class<Translation> getConcatenableClass() {
        return Translation.class;
    }

    public TranslationTransform preConcatenate(Translation t) {
        return this.concatenate(t);
    }

    @Override
    public Class<Translation> getPreConcatenableClass() {
        return Translation.class;
    }

    public void set(Translation transform) {
        assert (this.numTargetDimensions == transform.numTargetDimensions());
        transform.getTranslation(this.translation);
    }

    @Override
    public double[][] getMatrix() {
        double[][] mat = new double[this.numTargetDimensions + 1][this.numTargetDimensions + 1];
        mat[this.numTargetDimensions][this.numTargetDimensions] = 1.0;
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            mat[d][this.numTargetDimensions] = this.translation[d];
            mat[d][d] = 1.0;
        }
        return mat;
    }

    @Override
    public void applyInverse(long[] source, long[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            source[d] = target[d] - this.translation[d];
        }
    }

    @Override
    public void applyInverse(int[] source, int[] target) {
        assert (source.length >= this.numTargetDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            source[d] = target[d] - (int)this.translation[d];
        }
    }

    @Override
    public void applyInverse(Positionable source, Localizable target) {
        assert (source.numDimensions() >= this.numTargetDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            source.setPosition(target.getLongPosition(d) - this.translation[d], d);
        }
    }

    @Override
    public InverseTranslationTransform inverse() {
        return this.inverse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InverseTranslationTransform
    extends AbstractMixedTransform
    implements Translation,
    Concatenable<Translation>,
    PreConcatenable<Translation> {
        InverseTranslationTransform(int targetDim) {
            super(targetDim);
        }

        @Override
        public void apply(long[] source, long[] target) {
            TranslationTransform.this.applyInverse(target, source);
        }

        @Override
        public void apply(int[] source, int[] target) {
            TranslationTransform.this.applyInverse(target, source);
        }

        @Override
        public void apply(Localizable source, Positionable target) {
            TranslationTransform.this.applyInverse(target, source);
        }

        @Override
        public void applyInverse(long[] source, long[] target) {
            TranslationTransform.this.apply(target, source);
        }

        @Override
        public void applyInverse(int[] source, int[] target) {
            TranslationTransform.this.apply(target, source);
        }

        @Override
        public void applyInverse(Positionable source, Localizable target) {
            TranslationTransform.this.apply(target, source);
        }

        @Override
        public double[][] getMatrix() {
            double[][] mat = new double[this.numTargetDimensions + 1][this.numTargetDimensions + 1];
            mat[this.numTargetDimensions][this.numTargetDimensions] = 1.0;
            for (int d = 0; d < this.numTargetDimensions; ++d) {
                mat[d][this.numTargetDimensions] = -TranslationTransform.this.translation[d];
                mat[d][d] = 1.0;
            }
            return mat;
        }

        @Override
        public TranslationTransform inverse() {
            return TranslationTransform.this;
        }

        @Override
        public void getTranslation(long[] t) {
            assert (t.length == this.numTargetDimensions);
            for (int d = 0; d < this.numTargetDimensions; ++d) {
                t[d] = -TranslationTransform.this.translation[d];
            }
        }

        @Override
        public long getTranslation(int d) {
            assert (d <= this.numTargetDimensions);
            return -TranslationTransform.this.translation[d];
        }

        public TranslationTransform concatenate(Translation t) {
            assert (this.numTargetDimensions == t.numTargetDimensions());
            TranslationTransform result = new TranslationTransform(this.numTargetDimensions);
            for (int d = 0; d < this.numTargetDimensions; ++d) {
                result.translation[d] = t.getTranslation(d) - TranslationTransform.this.translation[d];
            }
            return result;
        }

        @Override
        public Class<Translation> getConcatenableClass() {
            return Translation.class;
        }

        public TranslationTransform preConcatenate(Translation t) {
            return this.concatenate(t);
        }

        @Override
        public Class<Translation> getPreConcatenableClass() {
            return Translation.class;
        }
    }
}

