/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.transform.InvertibleTransform;

public class SequentializeTransform
implements InvertibleTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;
    protected final int maxSourceDimension;
    protected final int maxTargetDimension;
    protected final long[] seqDimensions;
    protected final InvertibleTransform inverse;

    public SequentializeTransform(long[] sourceDimensions, int numTargetDimensions) {
        this.numSourceDimensions = sourceDimensions.length;
        this.numTargetDimensions = numTargetDimensions;
        this.maxTargetDimension = numTargetDimensions - 1;
        this.maxSourceDimension = this.numSourceDimensions - 1;
        assert (this.numSourceDimensions > this.numTargetDimensions);
        this.seqDimensions = new long[this.numSourceDimensions];
        for (int d = this.maxTargetDimension; d < this.numSourceDimensions; ++d) {
            this.seqDimensions[d] = sourceDimensions[d];
        }
        this.inverse = new InvertibleTransform(){

            public int numSourceDimensions() {
                return SequentializeTransform.this.numTargetDimensions();
            }

            public int numTargetDimensions() {
                return SequentializeTransform.this.numSourceDimensions();
            }

            public void apply(long[] source, long[] target) {
                SequentializeTransform.this.applyInverse(target, source);
            }

            public void apply(int[] source, int[] target) {
                SequentializeTransform.this.applyInverse(target, source);
            }

            public void apply(Localizable source, Positionable target) {
                SequentializeTransform.this.applyInverse(target, source);
            }

            public void applyInverse(long[] source, long[] target) {
                SequentializeTransform.this.apply(target, source);
            }

            public void applyInverse(int[] source, int[] target) {
                SequentializeTransform.this.apply(target, source);
            }

            public void applyInverse(Positionable source, Localizable target) {
                SequentializeTransform.this.apply(target, source);
            }

            public InvertibleTransform inverse() {
                return SequentializeTransform.this;
            }
        };
    }

    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.maxTargetDimension; ++d) {
            target[d] = source[d];
        }
        long i = source[this.maxSourceDimension];
        for (int d = this.maxSourceDimension - 1; d >= this.maxTargetDimension; --d) {
            i = i * this.seqDimensions[d] + source[d];
        }
        target[this.maxTargetDimension] = i;
    }

    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.maxTargetDimension; ++d) {
            target[d] = source[d];
        }
        int i = source[this.maxSourceDimension];
        for (int d = this.maxSourceDimension - 1; d >= this.maxTargetDimension; --d) {
            i = i * (int)this.seqDimensions[d] + source[d];
        }
        target[this.maxTargetDimension] = i;
    }

    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numSourceDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.maxTargetDimension; ++d) {
            target.setPosition(source.getLongPosition(d), d);
        }
        long i = source.getLongPosition(this.maxSourceDimension);
        for (int d = this.maxSourceDimension - 1; d >= this.maxTargetDimension; --d) {
            i = i * this.seqDimensions[d] + source.getLongPosition(d);
        }
        target.setPosition(i, this.maxTargetDimension);
    }

    public void applyInverse(long[] source, long[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.maxTargetDimension; ++d) {
            source[d] = target[d];
        }
        long i = target[this.maxTargetDimension];
        for (int d = this.maxTargetDimension; d < this.maxSourceDimension; ++d) {
            long j = i / this.seqDimensions[d];
            source[d] = i - j * this.seqDimensions[d];
            i = j;
        }
        source[this.maxSourceDimension] = i;
    }

    public void applyInverse(int[] source, int[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.maxTargetDimension; ++d) {
            source[d] = target[d];
        }
        int i = target[this.maxTargetDimension];
        for (int d = this.maxTargetDimension; d < this.maxSourceDimension; ++d) {
            int j = (int)((long)i / this.seqDimensions[d]);
            source[d] = (int)((long)i - (long)j * this.seqDimensions[d]);
            i = j;
        }
        source[this.maxSourceDimension] = i;
    }

    public void applyInverse(Positionable source, Localizable target) {
        assert (source.numDimensions() >= this.numSourceDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.maxTargetDimension; ++d) {
            source.setPosition(target.getLongPosition(d), d);
        }
        long i = target.getLongPosition(this.maxTargetDimension);
        for (int d = this.maxTargetDimension; d < this.maxSourceDimension; ++d) {
            long j = i / this.seqDimensions[d];
            source.setPosition(i - j * this.seqDimensions[d], d);
            i = j;
        }
        source.setPosition(i, this.maxSourceDimension);
    }

    public InvertibleTransform inverse() {
        return this.inverse;
    }
}

