/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.Mixed;

public abstract class AbstractMixedTransform
implements Mixed {
    protected final int numTargetDimensions;

    protected AbstractMixedTransform(int numTargetDimensions) {
        this.numTargetDimensions = numTargetDimensions;
    }

    public int numSourceDimensions() {
        return this.numTargetDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    public void getTranslation(long[] translation) {
        assert (translation.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            translation[d] = 0L;
        }
    }

    public long getTranslation(int d) {
        return 0L;
    }

    public void getComponentZero(boolean[] zero) {
        assert (zero.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            zero[d] = false;
        }
    }

    public boolean getComponentZero(int d) {
        return false;
    }

    public void getComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            component[d] = d;
        }
    }

    public int getComponentMapping(int d) {
        return d;
    }

    public void getComponentInversion(boolean[] invert) {
        assert (invert.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            invert[d] = false;
        }
    }

    public boolean getComponentInversion(int d) {
        return false;
    }

    public BoundingBox transform(BoundingBox boundingBox) {
        assert (boundingBox.numDimensions() == this.numSourceDimensions());
        if (this.numSourceDimensions() == this.numTargetDimensions) {
            long[] tmp = new long[this.numTargetDimensions];
            boundingBox.corner1(tmp);
            this.apply(tmp, boundingBox.corner1);
            boundingBox.corner2(tmp);
            this.apply(tmp, boundingBox.corner2);
            return boundingBox;
        }
        BoundingBox b = new BoundingBox(this.numTargetDimensions);
        this.apply(boundingBox.corner1, b.corner1);
        this.apply(boundingBox.corner2, b.corner2);
        return b;
    }
}

