/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.roi.AbstractIterableRegionOfInterest;

public class RectangleRegionOfInterest
extends AbstractIterableRegionOfInterest {
    private final double[] origin;
    private final double[] extent;

    public RectangleRegionOfInterest(double[] origin, double[] extent) {
        super(origin.length);
        this.origin = origin;
        this.extent = extent;
    }

    public void getOrigin(RealPositionable ptOrigin) {
        ptOrigin.setPosition(this.origin);
    }

    public void getOrigin(double[] org) {
        System.arraycopy(this.origin, 0, org, 0, this.numDimensions());
    }

    public double getOrigin(int d) {
        return this.origin[d];
    }

    public void setOrigin(RealLocalizable ptOrigin) {
        ptOrigin.localize(this.origin);
        this.invalidateCachedState();
    }

    public void setOrigin(double[] origin) {
        System.arraycopy(origin, 0, this.origin, 0, this.numDimensions());
        this.invalidateCachedState();
    }

    public void setOrigin(double origin, int d) {
        this.origin[d] = origin;
        this.invalidateCachedState();
    }

    public void setExtent(double[] extent) {
        System.arraycopy(extent, 0, this.extent, 0, this.numDimensions());
        this.invalidateCachedState();
    }

    public void setExtent(double extent, int d) {
        this.extent[d] = extent;
        this.invalidateCachedState();
    }

    public void getExtent(RealPositionable p) {
        p.setPosition(this.extent);
    }

    public void getExtent(double[] ext) {
        System.arraycopy(this.extent, 0, ext, 0, this.numDimensions());
    }

    public double getExtent(int d) {
        return this.extent[d];
    }

    protected boolean nextRaster(long[] position, long[] end) {
        int i;
        for (i = this.numDimensions() - 1; i >= 0; --i) {
            if (position[i] >= this.min(i)) continue;
            while (i >= 0) {
                position[i] = end[i] = this.min(i);
                --i;
            }
            end[0] = this.max(0) + 1L;
            return true;
        }
        position[0] = this.min(0);
        end[0] = this.max(0) + 1L;
        for (i = 1; i < this.numDimensions(); ++i) {
            position[i] = end[i] = position[i] + 1L;
            if (position[i] <= this.max(i)) {
                return true;
            }
            position[i] = end[i] = this.min(i);
        }
        return false;
    }

    public boolean contains(double[] position) {
        for (int i = 0; i < this.numDimensions(); ++i) {
            if (position[i] < this.realMin(i)) {
                return false;
            }
            if (!(position[i] >= this.realMax(i))) continue;
            return false;
        }
        return true;
    }

    protected long size() {
        long product = 1L;
        for (int i = 0; i < this.numDimensions(); ++i) {
            product *= this.max(i) - this.min(i) + 1L;
        }
        return product;
    }

    protected void getExtrema(long[] minima, long[] maxima) {
        for (int i = 0; i < this.numDimensions(); ++i) {
            minima[i] = (long)Math.ceil(this.origin[i]);
            maxima[i] = (long)Math.ceil(this.origin[i] + this.extent[i]) - 1L;
        }
    }

    protected void getRealExtrema(double[] minima, double[] maxima) {
        System.arraycopy(this.origin, 0, minima, 0, this.numDimensions());
        for (int i = 0; i < this.numDimensions(); ++i) {
            maxima[i] = this.origin[i] + this.extent[i];
        }
    }

    public void move(double displacement, int d) {
        double newVal = this.getOrigin(d) + displacement;
        this.setOrigin(newVal, d);
    }
}

