/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.RealRandomAccess;
import net.imglib2.roi.AbstractRegionOfInterest;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.type.logic.BitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CompositeRegionOfInterest
extends AbstractRegionOfInterest {
    private final ArrayList<RegionOfInterest> rois = new ArrayList();
    private final Map<RegionOfInterest, Operation> operations = new HashMap<RegionOfInterest, Operation>();
    private final ThreadLocal<Map<RegionOfInterest, RealRandomAccess<BitType>>> randomAccess = new ThreadLocal();

    public CompositeRegionOfInterest(int nDimensions) {
        super(nDimensions);
    }

    public CompositeRegionOfInterest(RegionOfInterest roi) {
        super(roi.numDimensions());
        this.rois.add(roi);
        this.operations.put(roi, Operation.OR);
    }

    public CompositeRegionOfInterest(Collection<RegionOfInterest> rois) {
        super(rois.size() == 0 ? 0 : rois.iterator().next().numDimensions());
        for (RegionOfInterest roi : rois) {
            this.rois.add(roi);
            this.operations.put(roi, Operation.OR);
        }
    }

    public void or(RegionOfInterest roi) {
        this.rois.add(roi);
        this.operations.put(roi, Operation.OR);
    }

    public void remove(RegionOfInterest roi) {
        this.rois.remove(roi);
        this.operations.remove(roi);
    }

    public void and(RegionOfInterest roi) {
        this.rois.add(roi);
        this.operations.put(roi, Operation.AND);
    }

    public void xor(RegionOfInterest roi) {
        this.rois.add(roi);
        this.operations.put(roi, Operation.XOR);
    }

    public void not(RegionOfInterest roi) {
        this.rois.add(roi);
        this.operations.put(roi, Operation.NOT);
    }

    @Override
    public void move(double displacement, int d) {
        for (RegionOfInterest roi : this.rois) {
            roi.move(displacement, d);
        }
    }

    @Override
    public boolean contains(double[] position) {
        boolean result = false;
        for (RegionOfInterest roi : this.rois) {
            Operation operation = this.operations.get(roi);
            switch (operation) {
                case AND: {
                    if (!result) break;
                    result = this.isMember(roi, position);
                    break;
                }
                case OR: {
                    if (result) break;
                    result = this.isMember(roi, position);
                    break;
                }
                case NOT: {
                    if (!result) break;
                    result = !this.isMember(roi, position);
                    break;
                }
                case XOR: {
                    result ^= this.isMember(roi, position);
                }
            }
        }
        return result;
    }

    private boolean isMember(RegionOfInterest roi, double[] position) {
        if (this.randomAccess.get() == null) {
            this.randomAccess.set(new HashMap());
        }
        if (!this.randomAccess.get().containsKey(roi)) {
            this.randomAccess.get().put(roi, roi.realRandomAccess());
        }
        RealRandomAccess<BitType> ra = this.randomAccess.get().get(roi);
        ra.setPosition(position);
        return ((BitType)ra.get()).get();
    }

    @Override
    protected void getRealExtrema(double[] minima, double[] maxima) {
        Arrays.fill(minima, Double.MAX_VALUE);
        Arrays.fill(maxima, Double.MIN_VALUE);
        for (RegionOfInterest roi : this.rois) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                minima[i] = Math.min(minima[i], roi.realMin(i));
                maxima[i] = Math.max(maxima[i], roi.realMax(i));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        OR,
        AND,
        XOR,
        NOT;

    }
}

