/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.position.transform;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.position.transform.AbstractPositionableTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Round<LocalizablePositionable extends Localizable & Positionable>
extends AbstractPositionableTransform<LocalizablePositionable> {
    public Round(LocalizablePositionable target) {
        super(target);
    }

    public Round(RealLocalizable origin, LocalizablePositionable target) {
        super(target);
        origin.localize(this.position);
        for (int d = 0; d < this.n; ++d) {
            this.discrete[d] = Round.round(this.position[d]);
        }
        ((Positionable)target).setPosition(this.discrete);
    }

    public static final long round(double r) {
        return r < 0.0 ? (long)(r - 0.5) : (long)(r + 0.5);
    }

    public static final long round(float r) {
        return r < 0.0f ? (long)(r - 0.5f) : (long)(r + 0.5f);
    }

    public static final void round(double[] r, long[] f) {
        for (int d = 0; d < r.length; ++d) {
            f[d] = Round.round(r[d]);
        }
    }

    public static final void round(float[] r, long[] f) {
        for (int d = 0; d < r.length; ++d) {
            f[d] = Round.round(r[d]);
        }
    }

    public static final void round(RealLocalizable r, long[] f) {
        for (int d = 0; d < f.length; ++d) {
            f[d] = Round.round(r.getDoublePosition(d));
        }
    }

    @Override
    public void move(float distance, int d) {
        double realPosition = this.position[d] + (double)distance;
        long roundPosition = Round.round(realPosition);
        this.position[d] = realPosition;
        long roundDistance = roundPosition - (long)this.target.getIntPosition(d);
        if (roundDistance == 0L) {
            return;
        }
        ((Positionable)((Object)this.target)).move(roundDistance, d);
    }

    @Override
    public void move(double distance, int d) {
        double realPosition = this.position[d] + distance;
        long roundPosition = Round.round(realPosition);
        this.position[d] = realPosition;
        long roundDistance = roundPosition - (long)this.target.getIntPosition(d);
        if (roundDistance == 0L) {
            return;
        }
        ((Positionable)((Object)this.target)).move(roundDistance, d);
    }

    @Override
    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + localizable.getDoublePosition(d);
            long floorPosition = Round.round(realPosition);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + (double)distance[d];
            long floorPosition = Round.round(realPosition);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + distance[d];
            long floorPosition = Round.round(realPosition);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        localizable.localize(this.position);
        for (int d = 0; d < this.n; ++d) {
            this.discrete[d] = Round.round(this.position[d]);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(float[] pos) {
        for (int d = 0; d < this.n; ++d) {
            float realPosition = pos[d];
            this.position[d] = realPosition;
            this.discrete[d] = Round.round(realPosition);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(double[] pos) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition;
            this.position[d] = realPosition = pos[d];
            this.discrete[d] = Round.round(realPosition);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(float position, int d) {
        this.position[d] = position;
        ((Positionable)((Object)this.target)).setPosition(Round.round(position), d);
    }

    @Override
    public void setPosition(double position, int d) {
        this.position[d] = position;
        ((Positionable)((Object)this.target)).setPosition(Round.round(position), d);
    }
}

