/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.position.transform;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.position.transform.Round;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealPositionableRoundPositionable<P extends RealLocalizable & RealPositionable>
extends AbstractEuclideanSpace
implements RealPositionable,
RealLocalizable {
    protected final P source;
    protected final Positionable target;
    private final long[] round;

    public RealPositionableRoundPositionable(P source, Positionable target) {
        super(source.numDimensions());
        this.source = source;
        this.target = target;
        this.round = new long[this.n];
    }

    @Override
    public void move(float distance, int d) {
        ((RealPositionable)this.source).move(distance, d);
        this.target.setPosition(Round.round(this.source.getDoublePosition(d)), d);
    }

    @Override
    public void move(double distance, int d) {
        ((RealPositionable)this.source).move(distance, d);
        this.target.setPosition(Round.round(this.source.getDoublePosition(d)), d);
    }

    @Override
    public void move(RealLocalizable localizable) {
        ((RealPositionable)this.source).move(localizable);
        Round.round(this.source, this.round);
        this.target.setPosition(this.round);
    }

    @Override
    public void move(float[] distance) {
        ((RealPositionable)this.source).move(distance);
        Round.round(this.source, this.round);
        this.target.setPosition(this.round);
    }

    @Override
    public void move(double[] distance) {
        ((RealPositionable)this.source).move(distance);
        Round.round(this.source, this.round);
        this.target.setPosition(this.round);
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        ((RealPositionable)this.source).setPosition(localizable);
        Round.round(localizable, this.round);
        this.target.setPosition(this.round);
    }

    @Override
    public void setPosition(float[] position) {
        ((RealPositionable)this.source).setPosition(position);
        Round.round(position, this.round);
        this.target.setPosition(this.round);
    }

    @Override
    public void setPosition(double[] position) {
        ((RealPositionable)this.source).setPosition(position);
        Round.round(position, this.round);
        this.target.setPosition(this.round);
    }

    @Override
    public void setPosition(float position, int dim) {
        ((RealPositionable)this.source).setPosition(position, dim);
        this.target.setPosition(Round.round(position), dim);
    }

    @Override
    public void setPosition(double position, int dim) {
        ((RealPositionable)this.source).setPosition(position, dim);
        this.target.setPosition(Round.round(position), dim);
    }

    @Override
    public void bck(int dim) {
        ((Positionable)this.source).bck(dim);
        this.target.bck(dim);
    }

    @Override
    public void fwd(int dim) {
        ((Positionable)this.source).fwd(dim);
        this.target.fwd(dim);
    }

    @Override
    public void move(int distance, int d) {
        ((Positionable)this.source).move(distance, d);
        this.target.move(distance, d);
    }

    @Override
    public void move(long distance, int d) {
        ((Positionable)this.source).move(distance, d);
        this.target.move(distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        ((Positionable)this.source).move(localizable);
        this.target.move(localizable);
    }

    @Override
    public void move(int[] pos) {
        ((Positionable)this.source).move(pos);
        this.target.move(pos);
    }

    @Override
    public void move(long[] pos) {
        ((Positionable)this.source).move(pos);
        this.target.move(pos);
    }

    @Override
    public void setPosition(Localizable localizable) {
        ((Positionable)this.source).setPosition(localizable);
        this.target.setPosition(localizable);
    }

    @Override
    public void setPosition(int[] position) {
        ((Positionable)this.source).setPosition(position);
        this.target.setPosition(position);
    }

    @Override
    public void setPosition(long[] position) {
        ((Positionable)this.source).setPosition(position);
        this.target.setPosition(position);
    }

    @Override
    public void setPosition(int position, int d) {
        ((Positionable)this.source).setPosition(position, d);
        this.target.setPosition(position, d);
    }

    @Override
    public void setPosition(long position, int d) {
        ((Positionable)this.source).setPosition(position, d);
        this.target.setPosition(position, d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.source.getDoublePosition(d);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.source.getFloatPosition(d);
    }

    @Override
    public void localize(float[] position) {
        this.source.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.source.localize(position);
    }
}

