/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.position.transform;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.position.transform.AbstractPositionableTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Floor<LocalizablePositionable extends Localizable & Positionable>
extends AbstractPositionableTransform<LocalizablePositionable> {
    public Floor(LocalizablePositionable target) {
        super(target);
    }

    public Floor(RealLocalizable origin, LocalizablePositionable target) {
        super(target);
        origin.localize(this.position);
        for (int d = 0; d < this.n; ++d) {
            ((Positionable)target).setPosition(Floor.floor(this.position[d]), d);
        }
    }

    public static final long floor(double r) {
        return r < 0.0 ? (long)r - 1L : (long)r;
    }

    public static final long floor(float r) {
        return r < 0.0f ? (long)r - 1L : (long)r;
    }

    public static final void floor(double[] r, long[] f) {
        for (int d = 0; d < r.length; ++d) {
            f[d] = Floor.floor(r[d]);
        }
    }

    public static final void floor(float[] r, long[] f) {
        for (int d = 0; d < r.length; ++d) {
            f[d] = Floor.floor(r[d]);
        }
    }

    public static final void floor(RealLocalizable r, long[] f) {
        for (int d = 0; d < f.length; ++d) {
            f[d] = Floor.floor(r.getDoublePosition(d));
        }
    }

    @Override
    public void move(float distance, int d) {
        double realPosition = this.position[d] + (double)distance;
        long floorPosition = Floor.floor(realPosition);
        this.position[d] = realPosition;
        long floorDistance = floorPosition - this.target.getLongPosition(d);
        if (floorDistance == 0L) {
            return;
        }
        ((Positionable)((Object)this.target)).move(floorDistance, d);
    }

    @Override
    public void move(double distance, int d) {
        double realPosition = this.position[d] + distance;
        long floorPosition = Floor.floor(realPosition);
        this.position[d] = realPosition;
        long floorDistance = floorPosition - this.target.getLongPosition(d);
        if (floorDistance == 0L) {
            return;
        }
        ((Positionable)((Object)this.target)).move(floorDistance, d);
    }

    @Override
    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + localizable.getDoublePosition(d);
            long floorPosition = Floor.floor(realPosition);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + (double)distance[d];
            long floorPosition = Floor.floor(realPosition);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            double realPosition = this.position[d] + distance[d];
            long floorPosition = Floor.floor(realPosition);
            this.position[d] = realPosition;
            this.discrete[d] = floorPosition - this.target.getLongPosition(d);
        }
        ((Positionable)((Object)this.target)).move(this.discrete);
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        localizable.localize(this.position);
        for (int d = 0; d < this.n; ++d) {
            this.discrete[d] = Floor.floor(this.position[d]);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(float[] pos) {
        for (int d = 0; d < this.n; ++d) {
            float realPosition = pos[d];
            this.position[d] = realPosition;
            this.discrete[d] = Floor.floor(realPosition);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
            this.discrete[d] = Floor.floor(position[d]);
        }
        ((Positionable)((Object)this.target)).setPosition(this.discrete);
    }

    @Override
    public void setPosition(float position, int dim) {
        this.position[dim] = position;
        ((Positionable)((Object)this.target)).setPosition(Floor.floor(position), dim);
    }

    @Override
    public void setPosition(double position, int dim) {
        this.position[dim] = position;
        ((Positionable)((Object)this.target)).setPosition(Floor.floor(position), dim);
    }
}

