/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import java.util.Random;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.AbstractOutOfBoundsValue;
import net.imglib2.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfBoundsRandomValue<T extends RealType<T>>
extends AbstractOutOfBoundsValue<T> {
    final T value;
    final double min;
    final double max;
    final double range;
    final Random rnd;

    protected OutOfBoundsRandomValue(OutOfBoundsRandomValue<T> outOfBounds) {
        super(outOfBounds);
        this.value = (RealType)outOfBounds.value.copy();
        this.min = outOfBounds.min;
        this.max = outOfBounds.max;
        this.range = outOfBounds.range;
        this.rnd = new Random();
    }

    public <F extends Interval & RandomAccessible<T>> OutOfBoundsRandomValue(F f, T value, Random rnd, double min, double max) {
        super(f);
        this.value = value;
        this.rnd = rnd;
        this.min = min;
        this.max = max;
        this.range = max - min;
    }

    @Override
    public final T get() {
        if (this.isOutOfBounds) {
            this.value.setReal(this.rnd.nextDouble() * this.range + this.min);
            return this.value;
        }
        return (T)((RealType)this.sampler.get());
    }

    @Override
    public final OutOfBoundsRandomValue<T> copy() {
        return new OutOfBoundsRandomValue<T>(this);
    }

    @Override
    public final OutOfBoundsRandomValue<T> copyRandomAccess() {
        return this.copy();
    }
}

