/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorExpWindowing;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfBoundsMirrorExpWindowingFactory<T extends NumericType<T>, F extends Interval & RandomAccessible<T>>
implements OutOfBoundsFactory<T, F> {
    int[] fadeOutDistance = null;
    int minFadeOutDistance = 6;
    int commonFadeOutDistance = 6;
    float commonRelativeDistanceFadeOut = Float.NaN;
    float exponent = 10.0f;

    public OutOfBoundsMirrorExpWindowingFactory() {
    }

    public OutOfBoundsMirrorExpWindowingFactory(float relativeDistanceFadeOut) {
        this.commonRelativeDistanceFadeOut = relativeDistanceFadeOut;
    }

    public OutOfBoundsMirrorExpWindowingFactory(int fadeOutDistance) {
        this.commonFadeOutDistance = fadeOutDistance;
    }

    public OutOfBoundsMirrorExpWindowingFactory(int[] fadeOutDistance) {
        this.fadeOutDistance = (int[])fadeOutDistance.clone();
    }

    public void setExponent(float exponent) {
        this.exponent = exponent;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setMinFadeOutDistance(int minFadeOutDistance) {
        this.minFadeOutDistance = minFadeOutDistance;
    }

    public long getMinFadeOutDistance() {
        return this.minFadeOutDistance;
    }

    public void setCommonFadeOutDistance(int fadeOutDistance) {
        this.commonFadeOutDistance = fadeOutDistance;
    }

    public long getCommonFadeOutDistance() {
        return this.commonFadeOutDistance;
    }

    public void setCommonRelativeFadeOutDistance(float commonRelativeDistanceFadeOut) {
        this.commonRelativeDistanceFadeOut = commonRelativeDistanceFadeOut;
    }

    public float getCommonRelativeFadeOutDistance() {
        return this.commonRelativeDistanceFadeOut;
    }

    public void setFadeOutDistance(int[] fadeOutDistance) {
        this.fadeOutDistance = (int[])fadeOutDistance.clone();
    }

    public int[] getFadeOutDistance() {
        return (int[])this.fadeOutDistance.clone();
    }

    @Override
    public OutOfBoundsMirrorExpWindowing<T> create(F f) {
        int numDimensions = f.numDimensions();
        if (Float.isNaN(this.commonRelativeDistanceFadeOut)) {
            if (this.fadeOutDistance == null) {
                this.fadeOutDistance = new int[numDimensions];
                for (int d = 0; d < numDimensions; ++d) {
                    this.fadeOutDistance[d] = Math.max(this.minFadeOutDistance, this.commonFadeOutDistance);
                }
            } else {
                for (int d = 0; d < numDimensions; ++d) {
                    this.fadeOutDistance[d] = Math.max(this.minFadeOutDistance, this.fadeOutDistance[d]);
                }
            }
        } else {
            if (this.commonRelativeDistanceFadeOut <= 0.0f) {
                this.commonRelativeDistanceFadeOut = 0.1f;
            }
            this.fadeOutDistance = new int[numDimensions];
            for (int d = 0; d < numDimensions; ++d) {
                this.fadeOutDistance[d] = Math.max(this.minFadeOutDistance, Util.round((float)f.dimension(d) * this.commonRelativeDistanceFadeOut) / 2);
            }
        }
        return new OutOfBoundsMirrorExpWindowing(f, this.fadeOutDistance, this.exponent);
    }
}

