/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutOfBoundsMirror<T>
implements OutOfBounds<T> {
    protected final RandomAccess<T> outOfBoundsRandomAccess;
    protected final int n;
    protected final long[] dimension;
    protected final long[] zeroMinPos;
    protected final long[] min;
    protected final long[] p;
    protected final boolean[] inc;
    protected final boolean[] dimIsOutOfBounds;
    protected boolean isOutOfBounds = false;

    protected AbstractOutOfBoundsMirror(AbstractOutOfBoundsMirror<T> outOfBounds) {
        this.n = outOfBounds.numDimensions();
        this.dimension = new long[this.n];
        this.min = new long[this.n];
        this.zeroMinPos = new long[this.n];
        this.p = new long[this.n];
        this.dimIsOutOfBounds = new boolean[this.n];
        this.inc = new boolean[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.dimension[d] = outOfBounds.dimension[d];
            this.min[d] = outOfBounds.min[d];
            this.zeroMinPos[d] = outOfBounds.zeroMinPos[d];
            this.p[d] = outOfBounds.p[d];
            this.dimIsOutOfBounds[d] = outOfBounds.dimIsOutOfBounds[d];
            this.inc[d] = outOfBounds.inc[d];
        }
        this.outOfBoundsRandomAccess = outOfBounds.outOfBoundsRandomAccess.copyRandomAccess();
    }

    public <F extends Interval & RandomAccessible<T>> AbstractOutOfBoundsMirror(F f) {
        this.n = f.numDimensions();
        this.dimension = new long[this.n];
        f.dimensions(this.dimension);
        this.min = new long[this.n];
        f.min(this.min);
        this.zeroMinPos = new long[this.n];
        this.p = new long[this.n];
        this.dimIsOutOfBounds = new boolean[this.n];
        this.inc = new boolean[this.n];
        for (int i = 0; i < this.dimension.length; ++i) {
            this.inc[i] = true;
        }
        this.outOfBoundsRandomAccess = ((RandomAccessible<T>)f).randomAccess();
    }

    protected final void checkOutOfBounds() {
        for (int d = 0; d < this.n; ++d) {
            if (!this.dimIsOutOfBounds[d]) continue;
            this.isOutOfBounds = true;
            return;
        }
        this.isOutOfBounds = false;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public boolean isOutOfBounds() {
        return this.isOutOfBounds;
    }

    @Override
    public T get() {
        return this.outOfBoundsRandomAccess.get();
    }

    @Override
    public abstract AbstractOutOfBoundsMirror<T> copy();

    @Override
    public void localize(float[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.zeroMinPos[d] + this.min[d];
        }
    }

    @Override
    public void localize(double[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.zeroMinPos[d] + this.min[d];
        }
    }

    @Override
    public void localize(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = (int)(this.zeroMinPos[d] + this.min[d]);
        }
    }

    @Override
    public void localize(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            pos[d] = this.zeroMinPos[d] + this.min[d];
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.zeroMinPos[d] + this.min[d];
    }

    @Override
    public double getDoublePosition(int d) {
        return this.zeroMinPos[d] + this.min[d];
    }

    @Override
    public int getIntPosition(int d) {
        return (int)(this.zeroMinPos[d] + this.min[d]);
    }

    @Override
    public long getLongPosition(int d) {
        return this.zeroMinPos[d] + this.min[d];
    }

    @Override
    public void move(long distance, int d) {
        this.setPosition(this.getLongPosition(d) + distance, d);
    }

    @Override
    public void move(int distance, int d) {
        this.move((long)distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.move(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.setPosition((long)position, d);
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }

    public String toString() {
        return Util.printCoordinates(this.zeroMinPos) + " = " + this.get();
    }
}

