/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.collection.KDTree;
import net.imglib2.collection.KDTreeNode;
import net.imglib2.neighborsearch.RadiusNeighborSearch;
import net.imglib2.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiusNeighborSearchOnKDTree<T>
implements RadiusNeighborSearch<T> {
    protected KDTree<T> tree;
    protected final int n;
    protected final double[] pos;
    protected ArrayList<Pair<KDTreeNode<T>, Double>> resultPoints;

    public RadiusNeighborSearchOnKDTree(KDTree<T> tree) {
        this.tree = tree;
        this.n = tree.numDimensions();
        this.pos = new double[this.n];
        this.resultPoints = new ArrayList();
    }

    @Override
    public void search(RealLocalizable reference, double radius, boolean sortResults) {
        assert (radius >= 0.0);
        reference.localize(this.pos);
        this.resultPoints.clear();
        this.searchNode(this.tree.getRoot(), radius * radius);
        if (sortResults) {
            Collections.sort(this.resultPoints, new Comparator<Pair<KDTreeNode<T>, Double>>(){

                @Override
                public int compare(Pair<KDTreeNode<T>, Double> o1, Pair<KDTreeNode<T>, Double> o2) {
                    return Double.compare((Double)o1.b, (Double)o2.b);
                }
            });
        }
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    protected void searchNode(KDTreeNode<T> current, double squRadius) {
        KDTreeNode awayChild;
        double squDistance = current.squDistanceTo(this.pos);
        if (squDistance <= squRadius) {
            this.resultPoints.add(new Pair<KDTreeNode<T>, Double>(current, squDistance));
        }
        double axisDiff = this.pos[current.getSplitDimension()] - current.getSplitCoordinate();
        double axisSquDistance = axisDiff * axisDiff;
        boolean leftIsNearBranch = axisDiff < 0.0;
        KDTreeNode nearChild = leftIsNearBranch ? current.left : current.right;
        KDTreeNode kDTreeNode = awayChild = leftIsNearBranch ? current.right : current.left;
        if (nearChild != null) {
            this.searchNode(nearChild, squRadius);
        }
        if (axisSquDistance <= squRadius && awayChild != null) {
            this.searchNode(awayChild, squRadius);
        }
    }

    @Override
    public int numNeighbors() {
        return this.resultPoints.size();
    }

    @Override
    public Sampler<T> getSampler(int i) {
        return (Sampler)this.resultPoints.get((int)i).a;
    }

    @Override
    public RealLocalizable getPosition(int i) {
        return (RealLocalizable)this.resultPoints.get((int)i).a;
    }

    @Override
    public double getSquareDistance(int i) {
        return (Double)this.resultPoints.get((int)i).b;
    }

    @Override
    public double getDistance(int i) {
        return Math.sqrt((Double)this.resultPoints.get((int)i).b);
    }
}

