/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.collection.KDTree;
import net.imglib2.collection.KDTreeNode;
import net.imglib2.neighborsearch.KNearestNeighborSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KNearestNeighborSearchOnKDTree<T>
implements KNearestNeighborSearch<T> {
    protected KDTree<T> tree;
    protected final int n;
    protected final double[] pos;
    protected final int k;
    protected KDTreeNode<T>[] bestPoints;
    protected double[] bestSquDistances;

    public KNearestNeighborSearchOnKDTree(KDTree<T> tree, int k) {
        this.tree = tree;
        this.n = tree.numDimensions();
        this.pos = new double[this.n];
        this.k = k;
        this.bestPoints = new KDTreeNode[k];
        this.bestSquDistances = new double[k];
        for (int i = 0; i < k; ++i) {
            this.bestSquDistances[i] = Double.MAX_VALUE;
        }
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public void search(RealLocalizable reference) {
        reference.localize(this.pos);
        for (int i = 0; i < this.k; ++i) {
            this.bestSquDistances[i] = Double.MAX_VALUE;
        }
        this.searchNode(this.tree.getRoot());
    }

    protected void searchNode(KDTreeNode<T> current) {
        KDTreeNode awayChild;
        double squDistance = current.squDistanceTo(this.pos);
        if (squDistance < this.bestSquDistances[this.k - 1]) {
            int i = this.k - 1;
            int j = i - 1;
            while (i > 0 && squDistance < this.bestSquDistances[j]) {
                this.bestSquDistances[i] = this.bestSquDistances[j];
                this.bestPoints[i] = this.bestPoints[j];
                --i;
                --j;
            }
            this.bestSquDistances[i] = squDistance;
            this.bestPoints[i] = current;
        }
        double axisDiff = this.pos[current.getSplitDimension()] - current.getSplitCoordinate();
        double axisSquDistance = axisDiff * axisDiff;
        boolean leftIsNearBranch = axisDiff < 0.0;
        KDTreeNode nearChild = leftIsNearBranch ? current.left : current.right;
        KDTreeNode kDTreeNode = awayChild = leftIsNearBranch ? current.right : current.left;
        if (nearChild != null) {
            this.searchNode(nearChild);
        }
        if (axisSquDistance <= this.bestSquDistances[this.k - 1] && awayChild != null) {
            this.searchNode(awayChild);
        }
    }

    @Override
    public Sampler<T> getSampler(int i) {
        return this.bestPoints[i];
    }

    @Override
    public RealLocalizable getPosition(int i) {
        return this.bestPoints[i];
    }

    @Override
    public double getSquareDistance(int i) {
        return this.bestSquDistances[i];
    }

    @Override
    public double getDistance(int i) {
        return Math.sqrt(this.bestSquDistances[i]);
    }

    @Override
    public RealLocalizable getPosition() {
        return this.getPosition(0);
    }

    @Override
    public Sampler<T> getSampler() {
        return this.getSampler(0);
    }

    @Override
    public double getSquareDistance() {
        return this.getSquareDistance(0);
    }

    @Override
    public double getDistance() {
        return this.getDistance(0);
    }

    @Override
    public KNearestNeighborSearchOnKDTree<T> copy() {
        KNearestNeighborSearchOnKDTree<T> copy = new KNearestNeighborSearchOnKDTree<T>(this.tree, this.k);
        System.arraycopy(this.pos, 0, copy.pos, 0, this.pos.length);
        for (int i = 0; i < this.k; ++i) {
            copy.bestPoints[i] = this.bestPoints[i];
            copy.bestSquDistances[i] = this.bestSquDistances[i];
        }
        return copy;
    }
}

